// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.Property
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAssetPropertyOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetPropertyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetPropertyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetPropertyError(context, call, payload)
        }
        val builder = DescribeAssetPropertyResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetPropertyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetPropertyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetPropertyOperationBody(builder: DescribeAssetPropertyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetExternalId"))
    val ASSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetId"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val ASSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetName"))
    val ASSETPROPERTY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetProperty"))
    val COMPOSITEMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("compositeModel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETEXTERNALID_DESCRIPTOR)
        field(ASSETID_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(ASSETNAME_DESCRIPTOR)
        field(ASSETPROPERTY_DESCRIPTOR)
        field(COMPOSITEMODEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETEXTERNALID_DESCRIPTOR.index -> builder.assetExternalId = deserializeString()
                ASSETID_DESCRIPTOR.index -> builder.assetId = deserializeString()
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                ASSETNAME_DESCRIPTOR.index -> builder.assetName = deserializeString()
                ASSETPROPERTY_DESCRIPTOR.index -> builder.assetProperty = deserializePropertyDocument(deserializer)
                COMPOSITEMODEL_DESCRIPTOR.index -> builder.compositeModel = deserializeCompositeModelPropertyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
