// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModel
import aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelSummary
import aws.sdk.kotlin.services.iotsitewise.model.AssetHierarchy
import aws.sdk.kotlin.services.iotsitewise.model.AssetProperty
import aws.sdk.kotlin.services.iotsitewise.model.AssetStatus
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeAssetOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetError(context, call, payload)
        }
        val builder = DescribeAssetResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetOperationBody(builder: DescribeAssetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetArn"))
    val ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetCompositeModelSummaries"))
    val ASSETCOMPOSITEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetCompositeModels"))
    val ASSETCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetCreationDate"))
    val ASSETDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetDescription"))
    val ASSETEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetExternalId"))
    val ASSETHIERARCHIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetHierarchies"))
    val ASSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetId"))
    val ASSETLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetLastUpdateDate"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val ASSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetName"))
    val ASSETPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetProperties"))
    val ASSETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETARN_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELS_DESCRIPTOR)
        field(ASSETCREATIONDATE_DESCRIPTOR)
        field(ASSETDESCRIPTION_DESCRIPTOR)
        field(ASSETEXTERNALID_DESCRIPTOR)
        field(ASSETHIERARCHIES_DESCRIPTOR)
        field(ASSETID_DESCRIPTOR)
        field(ASSETLASTUPDATEDATE_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(ASSETNAME_DESCRIPTOR)
        field(ASSETPROPERTIES_DESCRIPTOR)
        field(ASSETSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETARN_DESCRIPTOR.index -> builder.assetArn = deserializeString()
                ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR.index -> builder.assetCompositeModelSummaries =
                    deserializer.deserializeList(ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetCompositeModelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetCompositeModelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCOMPOSITEMODELS_DESCRIPTOR.index -> builder.assetCompositeModels =
                    deserializer.deserializeList(ASSETCOMPOSITEMODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetCompositeModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetCompositeModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCREATIONDATE_DESCRIPTOR.index -> builder.assetCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ASSETDESCRIPTION_DESCRIPTOR.index -> builder.assetDescription = deserializeString()
                ASSETEXTERNALID_DESCRIPTOR.index -> builder.assetExternalId = deserializeString()
                ASSETHIERARCHIES_DESCRIPTOR.index -> builder.assetHierarchies =
                    deserializer.deserializeList(ASSETHIERARCHIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetHierarchy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetHierarchyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETID_DESCRIPTOR.index -> builder.assetId = deserializeString()
                ASSETLASTUPDATEDATE_DESCRIPTOR.index -> builder.assetLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                ASSETNAME_DESCRIPTOR.index -> builder.assetName = deserializeString()
                ASSETPROPERTIES_DESCRIPTOR.index -> builder.assetProperties =
                    deserializer.deserializeList(ASSETPROPERTIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetProperty>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetPropertyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETSTATUS_DESCRIPTOR.index -> builder.assetStatus = deserializeAssetStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
