// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.ActionDefinition
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelCompositeModelPathSegment
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelCompositeModelSummary
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelProperty
import aws.sdk.kotlin.services.iotsitewise.model.CompositionDetails
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeAssetModelCompositeModelOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetModelCompositeModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetModelCompositeModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetModelCompositeModelError(context, call, payload)
        }
        val builder = DescribeAssetModelCompositeModelResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetModelCompositeModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetModelCompositeModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetModelCompositeModelOperationBody(builder: DescribeAssetModelCompositeModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actionDefinitions"))
    val ASSETMODELCOMPOSITEMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelCompositeModelDescription"))
    val ASSETMODELCOMPOSITEMODELEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelCompositeModelExternalId"))
    val ASSETMODELCOMPOSITEMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelCompositeModelId"))
    val ASSETMODELCOMPOSITEMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelCompositeModelName"))
    val ASSETMODELCOMPOSITEMODELPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModelPath"))
    val ASSETMODELCOMPOSITEMODELPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModelProperties"))
    val ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModelSummaries"))
    val ASSETMODELCOMPOSITEMODELTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelCompositeModelType"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val COMPOSITIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("compositionDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONDEFINITIONS_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELDESCRIPTION_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELEXTERNALID_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELID_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELNAME_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELPATH_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELPROPERTIES_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELTYPE_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(COMPOSITIONDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONDEFINITIONS_DESCRIPTOR.index -> builder.actionDefinitions =
                    deserializer.deserializeList(ACTIONDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActionDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActionDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCOMPOSITEMODELDESCRIPTION_DESCRIPTOR.index -> builder.assetModelCompositeModelDescription = deserializeString()
                ASSETMODELCOMPOSITEMODELEXTERNALID_DESCRIPTOR.index -> builder.assetModelCompositeModelExternalId = deserializeString()
                ASSETMODELCOMPOSITEMODELID_DESCRIPTOR.index -> builder.assetModelCompositeModelId = deserializeString()
                ASSETMODELCOMPOSITEMODELNAME_DESCRIPTOR.index -> builder.assetModelCompositeModelName = deserializeString()
                ASSETMODELCOMPOSITEMODELPATH_DESCRIPTOR.index -> builder.assetModelCompositeModelPath =
                    deserializer.deserializeList(ASSETMODELCOMPOSITEMODELPATH_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelCompositeModelPathSegment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelCompositeModelPathSegmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCOMPOSITEMODELPROPERTIES_DESCRIPTOR.index -> builder.assetModelCompositeModelProperties =
                    deserializer.deserializeList(ASSETMODELCOMPOSITEMODELPROPERTIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelProperty>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelPropertyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR.index -> builder.assetModelCompositeModelSummaries =
                    deserializer.deserializeList(ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelCompositeModelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelCompositeModelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCOMPOSITEMODELTYPE_DESCRIPTOR.index -> builder.assetModelCompositeModelType = deserializeString()
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                COMPOSITIONDETAILS_DESCRIPTOR.index -> builder.compositionDetails = deserializeCompositionDetailsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
