// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetAssetPropertyAggregatesOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetAssetPropertyAggregatesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetAssetPropertyAggregatesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetAssetPropertyAggregatesError(context, call, payload)
        }
        val builder = BatchGetAssetPropertyAggregatesResponse.Builder()

        if (payload != null) {
            deserializeBatchGetAssetPropertyAggregatesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetAssetPropertyAggregatesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetAssetPropertyAggregatesOperationBody(builder: BatchGetAssetPropertyAggregatesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errorEntries"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SKIPPEDENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("skippedEntries"))
    val SUCCESSENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("successEntries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORENTRIES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SKIPPEDENTRIES_DESCRIPTOR)
        field(SUCCESSENTRIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORENTRIES_DESCRIPTOR.index -> builder.errorEntries =
                    deserializer.deserializeList(ERRORENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetAssetPropertyAggregatesErrorEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetAssetPropertyAggregatesErrorEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SKIPPEDENTRIES_DESCRIPTOR.index -> builder.skippedEntries =
                    deserializer.deserializeList(SKIPPEDENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetAssetPropertyAggregatesSkippedEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetAssetPropertyAggregatesSkippedEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSENTRIES_DESCRIPTOR.index -> builder.successEntries =
                    deserializer.deserializeList(SUCCESSENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetAssetPropertyAggregatesSuccessEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetAssetPropertyAggregatesSuccessEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
