// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAssetModelRequest private constructor(builder: Builder) {
    /**
     * The composite models that are part of this asset model. It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
     *
     * When creating custom composite models, you need to use [CreateAssetModelCompositeModel](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html). For more information, see [Creating custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelCompositeModels: List<AssetModelCompositeModel>? = builder.assetModelCompositeModels
    /**
     * A description for the asset model.
     */
    public val assetModelDescription: kotlin.String? = builder.assetModelDescription
    /**
     * An external ID to assign to the asset model. The asset model must not already have an external ID. The external ID must be unique within your Amazon Web Services account. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val assetModelExternalId: kotlin.String? = builder.assetModelExternalId
    /**
     * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
     *
     * You can specify up to 10 hierarchies per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelHierarchies: List<AssetModelHierarchy>? = builder.assetModelHierarchies
    /**
     * The ID of the asset model to update. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetModelId: kotlin.String? = builder.assetModelId
    /**
     * A unique name for the asset model.
     */
    public val assetModelName: kotlin.String? = builder.assetModelName
    /**
     * The updated property definitions of the asset model. For more information, see [Asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html) in the *IoT SiteWise User Guide*.
     *
     * You can specify up to 200 properties per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelProperties: List<AssetModelProperty>? = builder.assetModelProperties
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The expected current entity tag (ETag) for the asset model’s latest or active version (specified using `matchForVersionType`). The update request is rejected if the tag does not match the latest or active version's current entity tag. See [Optimistic locking for asset model writes](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html) in the *IoT SiteWise User Guide*.
     */
    public val ifMatch: kotlin.String? = builder.ifMatch
    /**
     * Accepts ***** to reject the update request if an active version (specified using `matchForVersionType` as `ACTIVE`) already exists for the asset model.
     */
    public val ifNoneMatch: kotlin.String? = builder.ifNoneMatch
    /**
     * Specifies the asset model version type (`LATEST` or `ACTIVE`) used in conjunction with `If-Match` or `If-None-Match` headers to determine the target ETag for the update operation.
     */
    public val matchForVersionType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelVersionType? = builder.matchForVersionType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAssetModelRequest(")
        append("assetModelCompositeModels=$assetModelCompositeModels,")
        append("assetModelDescription=$assetModelDescription,")
        append("assetModelExternalId=$assetModelExternalId,")
        append("assetModelHierarchies=$assetModelHierarchies,")
        append("assetModelId=$assetModelId,")
        append("assetModelName=$assetModelName,")
        append("assetModelProperties=$assetModelProperties,")
        append("clientToken=$clientToken,")
        append("ifMatch=$ifMatch,")
        append("ifNoneMatch=$ifNoneMatch,")
        append("matchForVersionType=$matchForVersionType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelCompositeModels?.hashCode() ?: 0
        result = 31 * result + (assetModelDescription?.hashCode() ?: 0)
        result = 31 * result + (assetModelExternalId?.hashCode() ?: 0)
        result = 31 * result + (assetModelHierarchies?.hashCode() ?: 0)
        result = 31 * result + (assetModelId?.hashCode() ?: 0)
        result = 31 * result + (assetModelName?.hashCode() ?: 0)
        result = 31 * result + (assetModelProperties?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (ifNoneMatch?.hashCode() ?: 0)
        result = 31 * result + (matchForVersionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAssetModelRequest

        if (assetModelCompositeModels != other.assetModelCompositeModels) return false
        if (assetModelDescription != other.assetModelDescription) return false
        if (assetModelExternalId != other.assetModelExternalId) return false
        if (assetModelHierarchies != other.assetModelHierarchies) return false
        if (assetModelId != other.assetModelId) return false
        if (assetModelName != other.assetModelName) return false
        if (assetModelProperties != other.assetModelProperties) return false
        if (clientToken != other.clientToken) return false
        if (ifMatch != other.ifMatch) return false
        if (ifNoneMatch != other.ifNoneMatch) return false
        if (matchForVersionType != other.matchForVersionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The composite models that are part of this asset model. It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
         *
         * When creating custom composite models, you need to use [CreateAssetModelCompositeModel](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html). For more information, see [Creating custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelCompositeModels: List<AssetModelCompositeModel>? = null
        /**
         * A description for the asset model.
         */
        public var assetModelDescription: kotlin.String? = null
        /**
         * An external ID to assign to the asset model. The asset model must not already have an external ID. The external ID must be unique within your Amazon Web Services account. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var assetModelExternalId: kotlin.String? = null
        /**
         * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
         *
         * You can specify up to 10 hierarchies per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelHierarchies: List<AssetModelHierarchy>? = null
        /**
         * The ID of the asset model to update. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * A unique name for the asset model.
         */
        public var assetModelName: kotlin.String? = null
        /**
         * The updated property definitions of the asset model. For more information, see [Asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html) in the *IoT SiteWise User Guide*.
         *
         * You can specify up to 200 properties per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelProperties: List<AssetModelProperty>? = null
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The expected current entity tag (ETag) for the asset model’s latest or active version (specified using `matchForVersionType`). The update request is rejected if the tag does not match the latest or active version's current entity tag. See [Optimistic locking for asset model writes](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html) in the *IoT SiteWise User Guide*.
         */
        public var ifMatch: kotlin.String? = null
        /**
         * Accepts ***** to reject the update request if an active version (specified using `matchForVersionType` as `ACTIVE`) already exists for the asset model.
         */
        public var ifNoneMatch: kotlin.String? = null
        /**
         * Specifies the asset model version type (`LATEST` or `ACTIVE`) used in conjunction with `If-Match` or `If-None-Match` headers to determine the target ETag for the update operation.
         */
        public var matchForVersionType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelVersionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelRequest) : this() {
            this.assetModelCompositeModels = x.assetModelCompositeModels
            this.assetModelDescription = x.assetModelDescription
            this.assetModelExternalId = x.assetModelExternalId
            this.assetModelHierarchies = x.assetModelHierarchies
            this.assetModelId = x.assetModelId
            this.assetModelName = x.assetModelName
            this.assetModelProperties = x.assetModelProperties
            this.clientToken = x.clientToken
            this.ifMatch = x.ifMatch
            this.ifNoneMatch = x.ifNoneMatch
            this.matchForVersionType = x.matchForVersionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelRequest = UpdateAssetModelRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
