// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains an asset transform property. A transform is a one-to-one mapping of a property's data points from one form to another. For example, you can use a transform to convert a Celsius data stream to Fahrenheit by applying the transformation expression to each data point of the Celsius stream. A transform can only have a data type of `DOUBLE` and consume properties with data types of `INTEGER` or `DOUBLE`.
 *
 * For more information, see [Transforms](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms) in the *IoT SiteWise User Guide*.
 */
public class Transform private constructor(builder: Builder) {
    /**
     * The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression.
     *
     * For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
     */
    public val expression: kotlin.String = requireNotNull(builder.expression) { "A non-null value must be provided for expression" }
    /**
     * The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.
     */
    public val processingConfig: aws.sdk.kotlin.services.iotsitewise.model.TransformProcessingConfig? = builder.processingConfig
    /**
     * The list of variables used in the expression.
     */
    public val variables: List<ExpressionVariable> = requireNotNull(builder.variables) { "A non-null value must be provided for variables" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.Transform = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Transform(")
        append("expression=$expression,")
        append("processingConfig=$processingConfig,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expression.hashCode()
        result = 31 * result + (processingConfig?.hashCode() ?: 0)
        result = 31 * result + (variables.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Transform

        if (expression != other.expression) return false
        if (processingConfig != other.processingConfig) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.Transform = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression.
         *
         * For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
         */
        public var expression: kotlin.String? = null
        /**
         * The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.
         */
        public var processingConfig: aws.sdk.kotlin.services.iotsitewise.model.TransformProcessingConfig? = null
        /**
         * The list of variables used in the expression.
         */
        public var variables: List<ExpressionVariable>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.Transform) : this() {
            this.expression = x.expression
            this.processingConfig = x.processingConfig
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.Transform = Transform(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.TransformProcessingConfig] inside the given [block]
         */
        public fun processingConfig(block: aws.sdk.kotlin.services.iotsitewise.model.TransformProcessingConfig.Builder.() -> kotlin.Unit) {
            this.processingConfig = aws.sdk.kotlin.services.iotsitewise.model.TransformProcessingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (expression == null) expression = ""
            if (variables == null) variables = emptyList()
            return this
        }
    }
}
