// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains asset property value notification information. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see [Interacting with other services](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html) in the *IoT SiteWise User Guide*.
 */
public class PropertyNotification private constructor(builder: Builder) {
    /**
     * The current notification state.
     */
    public val state: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotificationState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The MQTT topic to which IoT SiteWise publishes property value update notifications.
     */
    public val topic: kotlin.String = requireNotNull(builder.topic) { "A non-null value must be provided for topic" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PropertyNotification(")
        append("state=$state,")
        append("topic=$topic")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = state.hashCode()
        result = 31 * result + (topic.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PropertyNotification

        if (state != other.state) return false
        if (topic != other.topic) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The current notification state.
         */
        public var state: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotificationState? = null
        /**
         * The MQTT topic to which IoT SiteWise publishes property value update notifications.
         */
        public var topic: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification) : this() {
            this.state = x.state
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification = PropertyNotification(this)

        internal fun correctErrors(): Builder {
            if (state == null) state = PropertyNotificationState.SdkUnknown("no value provided")
            if (topic == null) topic = ""
            return this
        }
    }
}
