// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAssociatedAssetsRequest private constructor(builder: Builder) {
    /**
     * The ID of the asset to query. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * (Optional) If you don't provide a `hierarchyId`, all the immediate assets in the `traversalDirection` will be returned.
     *
     *  The ID of the hierarchy by which child assets are associated to the asset. (This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.)
     *
     * For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
     */
    public val hierarchyId: kotlin.String? = builder.hierarchyId
    /**
     * The maximum number of results to return for each paginated request.
     *
     * Default: 50
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The direction to list associated assets. Choose one of the following options:
     * + `CHILD` – The list includes all child assets associated to the asset.
     * + `PARENT` – The list includes the asset's parent asset.
     *
     * Default: `CHILD`
     */
    public val traversalDirection: aws.sdk.kotlin.services.iotsitewise.model.TraversalDirection? = builder.traversalDirection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ListAssociatedAssetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssociatedAssetsRequest(")
        append("assetId=$assetId,")
        append("hierarchyId=$hierarchyId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("traversalDirection=$traversalDirection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (hierarchyId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (traversalDirection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAssociatedAssetsRequest

        if (assetId != other.assetId) return false
        if (hierarchyId != other.hierarchyId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (traversalDirection != other.traversalDirection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ListAssociatedAssetsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset to query. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetId: kotlin.String? = null
        /**
         * (Optional) If you don't provide a `hierarchyId`, all the immediate assets in the `traversalDirection` will be returned.
         *
         *  The ID of the hierarchy by which child assets are associated to the asset. (This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.)
         *
         * For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
         */
        public var hierarchyId: kotlin.String? = null
        /**
         * The maximum number of results to return for each paginated request.
         *
         * Default: 50
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The direction to list associated assets. Choose one of the following options:
         * + `CHILD` – The list includes all child assets associated to the asset.
         * + `PARENT` – The list includes the asset's parent asset.
         *
         * Default: `CHILD`
         */
        public var traversalDirection: aws.sdk.kotlin.services.iotsitewise.model.TraversalDirection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ListAssociatedAssetsRequest) : this() {
            this.assetId = x.assetId
            this.hierarchyId = x.hierarchyId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.traversalDirection = x.traversalDirection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ListAssociatedAssetsRequest = ListAssociatedAssetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
