// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAssetsRequest private constructor(builder: Builder) {
    /**
     * The ID of the asset model by which to filter the list of assets. This parameter is required if you choose `ALL` for `filter`. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetModelId: kotlin.String? = builder.assetModelId
    /**
     * The filter for the requested list of assets. Choose one of the following options:
     * + `ALL` – The list includes all assets for a given asset model ID. The `assetModelId` parameter is required if you filter by `ALL`.
     * + `TOP_LEVEL` – The list includes only top-level assets in the asset hierarchy tree.
     *
     * Default: `ALL`
     */
    public val filter: aws.sdk.kotlin.services.iotsitewise.model.ListAssetsFilter? = builder.filter
    /**
     * The maximum number of results to return for each paginated request.
     *
     * Default: 50
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ListAssetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssetsRequest(")
        append("assetModelId=$assetModelId,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelId?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAssetsRequest

        if (assetModelId != other.assetModelId) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ListAssetsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset model by which to filter the list of assets. This parameter is required if you choose `ALL` for `filter`. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * The filter for the requested list of assets. Choose one of the following options:
         * + `ALL` – The list includes all assets for a given asset model ID. The `assetModelId` parameter is required if you filter by `ALL`.
         * + `TOP_LEVEL` – The list includes only top-level assets in the asset hierarchy tree.
         *
         * Default: `ALL`
         */
        public var filter: aws.sdk.kotlin.services.iotsitewise.model.ListAssetsFilter? = null
        /**
         * The maximum number of results to return for each paginated request.
         *
         * Default: 50
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ListAssetsRequest) : this() {
            this.assetModelId = x.assetModelId
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ListAssetsRequest = ListAssetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
