// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAssetPropertiesRequest private constructor(builder: Builder) {
    /**
     * The ID of the asset. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * Filters the requested list of asset properties. You can choose one of the following options:
     * + `ALL` – The list includes all asset properties for a given asset model ID.
     * + `BASE` – The list includes only base asset properties for a given asset model ID.
     *
     * Default: `BASE`
     */
    public val filter: aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesFilter? = builder.filter
    /**
     * The maximum number of results to return for each paginated request. If not specified, the default value is 50.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssetPropertiesRequest(")
        append("assetId=$assetId,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAssetPropertiesRequest

        if (assetId != other.assetId) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetId: kotlin.String? = null
        /**
         * Filters the requested list of asset properties. You can choose one of the following options:
         * + `ALL` – The list includes all asset properties for a given asset model ID.
         * + `BASE` – The list includes only base asset properties for a given asset model ID.
         *
         * Default: `BASE`
         */
        public var filter: aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesFilter? = null
        /**
         * The maximum number of results to return for each paginated request. If not specified, the default value is 50.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesRequest) : this() {
            this.assetId = x.assetId
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesRequest = ListAssetPropertiesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
