// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAssetModelsRequest private constructor(builder: Builder) {
    /**
     * The type of asset model. If you don't provide an `assetModelTypes`, all types of asset models are returned.
     * + **ASSET_MODEL** – An asset model that you can use to create assets. Can't be included as a component in another asset model.
     * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
     */
    public val assetModelTypes: List<AssetModelType>? = builder.assetModelTypes
    /**
     * The version alias that specifies the latest or active version of the asset model. The details are returned in the response. The default value is `LATEST`. See [ Asset model versions](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelVersion: kotlin.String? = builder.assetModelVersion
    /**
     * The maximum number of results to return for each paginated request.
     *
     * Default: 50
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssetModelsRequest(")
        append("assetModelTypes=$assetModelTypes,")
        append("assetModelVersion=$assetModelVersion,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelTypes?.hashCode() ?: 0
        result = 31 * result + (assetModelVersion?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAssetModelsRequest

        if (assetModelTypes != other.assetModelTypes) return false
        if (assetModelVersion != other.assetModelVersion) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of asset model. If you don't provide an `assetModelTypes`, all types of asset models are returned.
         * + **ASSET_MODEL** – An asset model that you can use to create assets. Can't be included as a component in another asset model.
         * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
         */
        public var assetModelTypes: List<AssetModelType>? = null
        /**
         * The version alias that specifies the latest or active version of the asset model. The details are returned in the response. The default value is `LATEST`. See [ Asset model versions](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelVersion: kotlin.String? = null
        /**
         * The maximum number of results to return for each paginated request.
         *
         * Default: 50
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelsRequest) : this() {
            this.assetModelTypes = x.assetModelTypes
            this.assetModelVersion = x.assetModelVersion
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelsRequest = ListAssetModelsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
