// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details for a gateway that runs on IoT Greengrass V2. To create a gateway that runs on IoT Greengrass V2, you must deploy the IoT SiteWise Edge component to your gateway device. Your [Greengrass device role](https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html) must use the `AWSIoTSiteWiseEdgeAccess` policy. For more information, see [Using IoT SiteWise at the edge](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html) in the *IoT SiteWise User Guide*.
 */
public class GreengrassV2 private constructor(builder: Builder) {
    /**
     * The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required for MQTT-enabled, V3 gateways (`gatewayVersion``3`) and not applicable for Classic stream, V2 gateways (`gatewayVersion``2`).
     */
    public val coreDeviceOperatingSystem: aws.sdk.kotlin.services.iotsitewise.model.CoreDeviceOperatingSystem? = builder.coreDeviceOperatingSystem
    /**
     * The name of the IoT thing for your IoT Greengrass V2 core device.
     */
    public val coreDeviceThingName: kotlin.String = requireNotNull(builder.coreDeviceThingName) { "A non-null value must be provided for coreDeviceThingName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.GreengrassV2 = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GreengrassV2(")
        append("coreDeviceOperatingSystem=$coreDeviceOperatingSystem,")
        append("coreDeviceThingName=$coreDeviceThingName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreDeviceOperatingSystem?.hashCode() ?: 0
        result = 31 * result + (coreDeviceThingName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GreengrassV2

        if (coreDeviceOperatingSystem != other.coreDeviceOperatingSystem) return false
        if (coreDeviceThingName != other.coreDeviceThingName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.GreengrassV2 = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required for MQTT-enabled, V3 gateways (`gatewayVersion``3`) and not applicable for Classic stream, V2 gateways (`gatewayVersion``2`).
         */
        public var coreDeviceOperatingSystem: aws.sdk.kotlin.services.iotsitewise.model.CoreDeviceOperatingSystem? = null
        /**
         * The name of the IoT thing for your IoT Greengrass V2 core device.
         */
        public var coreDeviceThingName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.GreengrassV2) : this() {
            this.coreDeviceOperatingSystem = x.coreDeviceOperatingSystem
            this.coreDeviceThingName = x.coreDeviceThingName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.GreengrassV2 = GreengrassV2(this)

        internal fun correctErrors(): Builder {
            if (coreDeviceThingName == null) coreDeviceThingName = ""
            return this
        }
    }
}
