// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details for a gateway that runs on IoT Greengrass. To create a gateway that runs on IoT Greengrass, you must add the IoT SiteWise connector to a Greengrass group and deploy it. Your Greengrass group must also have permissions to upload data to IoT SiteWise. For more information, see [Ingesting data using a gateway](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html) in the *IoT SiteWise User Guide*.
 */
public class Greengrass private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Greengrass group. For more information about how to find a group's ARN, see [ListGroups](https://docs.aws.amazon.com/greengrass/v1/apireference/listgroups-get.html) and [GetGroup](https://docs.aws.amazon.com/greengrass/v1/apireference/getgroup-get.html) in the *IoT Greengrass V1 API Reference*.
     */
    public val groupArn: kotlin.String = requireNotNull(builder.groupArn) { "A non-null value must be provided for groupArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.Greengrass = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Greengrass(")
        append("groupArn=$groupArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupArn.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Greengrass

        if (groupArn != other.groupArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.Greengrass = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Greengrass group. For more information about how to find a group's ARN, see [ListGroups](https://docs.aws.amazon.com/greengrass/v1/apireference/listgroups-get.html) and [GetGroup](https://docs.aws.amazon.com/greengrass/v1/apireference/getgroup-get.html) in the *IoT Greengrass V1 API Reference*.
         */
        public var groupArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.Greengrass) : this() {
            this.groupArn = x.groupArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.Greengrass = Greengrass(this)

        internal fun correctErrors(): Builder {
            if (groupArn == null) groupArn = ""
            return this
        }
    }
}
