// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The file in Amazon S3 where your data is saved.
 */
public class File private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket from which data is imported.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The key of the Amazon S3 object that contains your data. Each object has a key that is a unique identifier. Each object has exactly one key.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The version ID to identify a specific version of the Amazon S3 object that contains your data.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.File = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("File(")
        append("bucket=$bucket,")
        append("key=$key,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (key.hashCode())
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as File

        if (bucket != other.bucket) return false
        if (key != other.key) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.File = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Amazon S3 bucket from which data is imported.
         */
        public var bucket: kotlin.String? = null
        /**
         * The key of the Amazon S3 object that contains your data. Each object has a key that is a unique identifier. Each object has exactly one key.
         */
        public var key: kotlin.String? = null
        /**
         * The version ID to identify a specific version of the Amazon S3 object that contains your data.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.File) : this() {
            this.bucket = x.bucket
            this.key = x.key
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.File = File(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (key == null) key = ""
            return this
        }
    }
}
