// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon S3 destination where errors associated with the job creation request are saved.
 */
public class ErrorReportLocation private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket to which errors associated with the bulk import job are sent.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Amazon S3 uses the prefix as a folder name to organize data in the bucket. Each Amazon S3 object has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val prefix: kotlin.String = requireNotNull(builder.prefix) { "A non-null value must be provided for prefix" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ErrorReportLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ErrorReportLocation(")
        append("bucket=$bucket,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (prefix.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ErrorReportLocation

        if (bucket != other.bucket) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ErrorReportLocation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Amazon S3 bucket to which errors associated with the bulk import job are sent.
         */
        public var bucket: kotlin.String? = null
        /**
         * Amazon S3 uses the prefix as a folder name to organize data in the bucket. Each Amazon S3 object has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ErrorReportLocation) : this() {
            this.bucket = x.bucket
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ErrorReportLocation = ErrorReportLocation(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (prefix == null) prefix = ""
            return this
        }
    }
}
