// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeProjectResponse private constructor(builder: Builder) {
    /**
     * The ID of the portal that the project is in.
     */
    public val portalId: kotlin.String = requireNotNull(builder.portalId) { "A non-null value must be provided for portalId" }
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the project, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}`
     */
    public val projectArn: kotlin.String = requireNotNull(builder.projectArn) { "A non-null value must be provided for projectArn" }
    /**
     * The date the project was created, in Unix epoch time.
     */
    public val projectCreationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.projectCreationDate) { "A non-null value must be provided for projectCreationDate" }
    /**
     * The project's description.
     */
    public val projectDescription: kotlin.String? = builder.projectDescription
    /**
     * The ID of the project.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * The date the project was last updated, in Unix epoch time.
     */
    public val projectLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.projectLastUpdateDate) { "A non-null value must be provided for projectLastUpdateDate" }
    /**
     * The name of the project.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeProjectResponse(")
        append("portalId=$portalId,")
        append("projectArn=$projectArn,")
        append("projectCreationDate=$projectCreationDate,")
        append("projectDescription=$projectDescription,")
        append("projectId=$projectId,")
        append("projectLastUpdateDate=$projectLastUpdateDate,")
        append("projectName=$projectName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = portalId.hashCode()
        result = 31 * result + (projectArn.hashCode())
        result = 31 * result + (projectCreationDate.hashCode())
        result = 31 * result + (projectDescription?.hashCode() ?: 0)
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (projectLastUpdateDate.hashCode())
        result = 31 * result + (projectName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeProjectResponse

        if (portalId != other.portalId) return false
        if (projectArn != other.projectArn) return false
        if (projectCreationDate != other.projectCreationDate) return false
        if (projectDescription != other.projectDescription) return false
        if (projectId != other.projectId) return false
        if (projectLastUpdateDate != other.projectLastUpdateDate) return false
        if (projectName != other.projectName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the portal that the project is in.
         */
        public var portalId: kotlin.String? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the project, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}`
         */
        public var projectArn: kotlin.String? = null
        /**
         * The date the project was created, in Unix epoch time.
         */
        public var projectCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The project's description.
         */
        public var projectDescription: kotlin.String? = null
        /**
         * The ID of the project.
         */
        public var projectId: kotlin.String? = null
        /**
         * The date the project was last updated, in Unix epoch time.
         */
        public var projectLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the project.
         */
        public var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse) : this() {
            this.portalId = x.portalId
            this.projectArn = x.projectArn
            this.projectCreationDate = x.projectCreationDate
            this.projectDescription = x.projectDescription
            this.projectId = x.projectId
            this.projectLastUpdateDate = x.projectLastUpdateDate
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse = DescribeProjectResponse(this)

        internal fun correctErrors(): Builder {
            if (portalId == null) portalId = ""
            if (projectArn == null) projectArn = ""
            if (projectCreationDate == null) projectCreationDate = Instant.fromEpochSeconds(0)
            if (projectId == null) projectId = ""
            if (projectLastUpdateDate == null) projectLastUpdateDate = Instant.fromEpochSeconds(0)
            if (projectName == null) projectName = ""
            return this
        }
    }
}
