// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeExecutionResponse private constructor(builder: Builder) {
    /**
     * The type of action exectued.
     */
    public val actionType: kotlin.String? = builder.actionType
    /**
     * Provides detailed information about the execution of your anomaly detection models. This includes model metrics and training timestamps for both training and inference actions.
     * +  The training action (Amazon Web Services/ANOMALY_DETECTION_TRAINING), includes performance metrics that help you compare different versions of your anomaly detection models. These metrics provide insights into the model's performance during the training process.
     * +  The inference action (Amazon Web Services/ANOMALY_DETECTION_INFERENCE), includes information about the results of executing your anomaly detection models. This helps you understand the output of your models and assess their performance.
     */
    public val executionDetails: Map<String, String>? = builder.executionDetails
    /**
     * The time the process ended.
     */
    public val executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionEndTime
    /**
     * Entity version used for the execution.
     */
    public val executionEntityVersion: kotlin.String? = builder.executionEntityVersion
    /**
     * The ID of the execution.
     */
    public val executionId: kotlin.String = requireNotNull(builder.executionId) { "A non-null value must be provided for executionId" }
    /**
     * The result of the execution.
     */
    public val executionResult: Map<String, String>? = builder.executionResult
    /**
     * The time the process started.
     */
    public val executionStartTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.executionStartTime) { "A non-null value must be provided for executionStartTime" }
    /**
     * The status of the execution process.
     */
    public val executionStatus: aws.sdk.kotlin.services.iotsitewise.model.ExecutionStatus? = builder.executionStatus
    /**
     * The detailed resource this execution resolves to.
     */
    public val resolveTo: aws.sdk.kotlin.services.iotsitewise.model.ResolveTo? = builder.resolveTo
    /**
     * The resource the action will be taken on.
     */
    public val targetResource: aws.sdk.kotlin.services.iotsitewise.model.TargetResource? = builder.targetResource
    /**
     * The version of the target resource.
     */
    public val targetResourceVersion: kotlin.String = requireNotNull(builder.targetResourceVersion) { "A non-null value must be provided for targetResourceVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeExecutionResponse(")
        append("actionType=$actionType,")
        append("executionDetails=$executionDetails,")
        append("executionEndTime=$executionEndTime,")
        append("executionEntityVersion=$executionEntityVersion,")
        append("executionId=$executionId,")
        append("executionResult=$executionResult,")
        append("executionStartTime=$executionStartTime,")
        append("executionStatus=$executionStatus,")
        append("resolveTo=$resolveTo,")
        append("targetResource=$targetResource,")
        append("targetResourceVersion=$targetResourceVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionType?.hashCode() ?: 0
        result = 31 * result + (executionDetails?.hashCode() ?: 0)
        result = 31 * result + (executionEndTime?.hashCode() ?: 0)
        result = 31 * result + (executionEntityVersion?.hashCode() ?: 0)
        result = 31 * result + (executionId.hashCode())
        result = 31 * result + (executionResult?.hashCode() ?: 0)
        result = 31 * result + (executionStartTime.hashCode())
        result = 31 * result + (executionStatus?.hashCode() ?: 0)
        result = 31 * result + (resolveTo?.hashCode() ?: 0)
        result = 31 * result + (targetResource?.hashCode() ?: 0)
        result = 31 * result + (targetResourceVersion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeExecutionResponse

        if (actionType != other.actionType) return false
        if (executionDetails != other.executionDetails) return false
        if (executionEndTime != other.executionEndTime) return false
        if (executionEntityVersion != other.executionEntityVersion) return false
        if (executionId != other.executionId) return false
        if (executionResult != other.executionResult) return false
        if (executionStartTime != other.executionStartTime) return false
        if (executionStatus != other.executionStatus) return false
        if (resolveTo != other.resolveTo) return false
        if (targetResource != other.targetResource) return false
        if (targetResourceVersion != other.targetResourceVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of action exectued.
         */
        public var actionType: kotlin.String? = null
        /**
         * Provides detailed information about the execution of your anomaly detection models. This includes model metrics and training timestamps for both training and inference actions.
         * +  The training action (Amazon Web Services/ANOMALY_DETECTION_TRAINING), includes performance metrics that help you compare different versions of your anomaly detection models. These metrics provide insights into the model's performance during the training process.
         * +  The inference action (Amazon Web Services/ANOMALY_DETECTION_INFERENCE), includes information about the results of executing your anomaly detection models. This helps you understand the output of your models and assess their performance.
         */
        public var executionDetails: Map<String, String>? = null
        /**
         * The time the process ended.
         */
        public var executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Entity version used for the execution.
         */
        public var executionEntityVersion: kotlin.String? = null
        /**
         * The ID of the execution.
         */
        public var executionId: kotlin.String? = null
        /**
         * The result of the execution.
         */
        public var executionResult: Map<String, String>? = null
        /**
         * The time the process started.
         */
        public var executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the execution process.
         */
        public var executionStatus: aws.sdk.kotlin.services.iotsitewise.model.ExecutionStatus? = null
        /**
         * The detailed resource this execution resolves to.
         */
        public var resolveTo: aws.sdk.kotlin.services.iotsitewise.model.ResolveTo? = null
        /**
         * The resource the action will be taken on.
         */
        public var targetResource: aws.sdk.kotlin.services.iotsitewise.model.TargetResource? = null
        /**
         * The version of the target resource.
         */
        public var targetResourceVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionResponse) : this() {
            this.actionType = x.actionType
            this.executionDetails = x.executionDetails
            this.executionEndTime = x.executionEndTime
            this.executionEntityVersion = x.executionEntityVersion
            this.executionId = x.executionId
            this.executionResult = x.executionResult
            this.executionStartTime = x.executionStartTime
            this.executionStatus = x.executionStatus
            this.resolveTo = x.resolveTo
            this.targetResource = x.targetResource
            this.targetResourceVersion = x.targetResourceVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionResponse = DescribeExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ExecutionStatus] inside the given [block]
         */
        public fun executionStatus(block: aws.sdk.kotlin.services.iotsitewise.model.ExecutionStatus.Builder.() -> kotlin.Unit) {
            this.executionStatus = aws.sdk.kotlin.services.iotsitewise.model.ExecutionStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ResolveTo] inside the given [block]
         */
        public fun resolveTo(block: aws.sdk.kotlin.services.iotsitewise.model.ResolveTo.Builder.() -> kotlin.Unit) {
            this.resolveTo = aws.sdk.kotlin.services.iotsitewise.model.ResolveTo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.TargetResource] inside the given [block]
         */
        public fun targetResource(block: aws.sdk.kotlin.services.iotsitewise.model.TargetResource.Builder.() -> kotlin.Unit) {
            this.targetResource = aws.sdk.kotlin.services.iotsitewise.model.TargetResource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (executionId == null) executionId = ""
            if (executionStartTime == null) executionStartTime = Instant.fromEpochSeconds(0)
            if (targetResourceVersion == null) targetResourceVersion = ""
            return this
        }
    }
}
