// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDatasetResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) of the dataset. The format is `arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}`.
     */
    public val datasetArn: kotlin.String = requireNotNull(builder.datasetArn) { "A non-null value must be provided for datasetArn" }
    /**
     * The dataset creation date, in Unix epoch time.
     */
    public val datasetCreationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.datasetCreationDate) { "A non-null value must be provided for datasetCreationDate" }
    /**
     * A description about the dataset, and its functionality.
     */
    public val datasetDescription: kotlin.String = requireNotNull(builder.datasetDescription) { "A non-null value must be provided for datasetDescription" }
    /**
     * The ID of the dataset.
     */
    public val datasetId: kotlin.String = requireNotNull(builder.datasetId) { "A non-null value must be provided for datasetId" }
    /**
     * The date the dataset was last updated, in Unix epoch time.
     */
    public val datasetLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.datasetLastUpdateDate) { "A non-null value must be provided for datasetLastUpdateDate" }
    /**
     * The name of the dataset.
     */
    public val datasetName: kotlin.String = requireNotNull(builder.datasetName) { "A non-null value must be provided for datasetName" }
    /**
     * The data source for the dataset.
     */
    public val datasetSource: aws.sdk.kotlin.services.iotsitewise.model.DatasetSource? = builder.datasetSource
    /**
     * The status of the dataset. This contains the state and any error messages. State is `CREATING` after a successfull call to this API, and any associated error message. The state is `ACTIVE` when ready to use.
     */
    public val datasetStatus: aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus? = builder.datasetStatus
    /**
     * The version of the dataset.
     */
    public val datasetVersion: kotlin.String? = builder.datasetVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDatasetResponse(")
        append("datasetArn=$datasetArn,")
        append("datasetCreationDate=$datasetCreationDate,")
        append("datasetDescription=$datasetDescription,")
        append("datasetId=$datasetId,")
        append("datasetLastUpdateDate=$datasetLastUpdateDate,")
        append("datasetName=$datasetName,")
        append("datasetSource=$datasetSource,")
        append("datasetStatus=$datasetStatus,")
        append("datasetVersion=$datasetVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetArn.hashCode()
        result = 31 * result + (datasetCreationDate.hashCode())
        result = 31 * result + (datasetDescription.hashCode())
        result = 31 * result + (datasetId.hashCode())
        result = 31 * result + (datasetLastUpdateDate.hashCode())
        result = 31 * result + (datasetName.hashCode())
        result = 31 * result + (datasetSource?.hashCode() ?: 0)
        result = 31 * result + (datasetStatus?.hashCode() ?: 0)
        result = 31 * result + (datasetVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDatasetResponse

        if (datasetArn != other.datasetArn) return false
        if (datasetCreationDate != other.datasetCreationDate) return false
        if (datasetDescription != other.datasetDescription) return false
        if (datasetId != other.datasetId) return false
        if (datasetLastUpdateDate != other.datasetLastUpdateDate) return false
        if (datasetName != other.datasetName) return false
        if (datasetSource != other.datasetSource) return false
        if (datasetStatus != other.datasetStatus) return false
        if (datasetVersion != other.datasetVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) of the dataset. The format is `arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}`.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The dataset creation date, in Unix epoch time.
         */
        public var datasetCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description about the dataset, and its functionality.
         */
        public var datasetDescription: kotlin.String? = null
        /**
         * The ID of the dataset.
         */
        public var datasetId: kotlin.String? = null
        /**
         * The date the dataset was last updated, in Unix epoch time.
         */
        public var datasetLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the dataset.
         */
        public var datasetName: kotlin.String? = null
        /**
         * The data source for the dataset.
         */
        public var datasetSource: aws.sdk.kotlin.services.iotsitewise.model.DatasetSource? = null
        /**
         * The status of the dataset. This contains the state and any error messages. State is `CREATING` after a successfull call to this API, and any associated error message. The state is `ACTIVE` when ready to use.
         */
        public var datasetStatus: aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus? = null
        /**
         * The version of the dataset.
         */
        public var datasetVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetResponse) : this() {
            this.datasetArn = x.datasetArn
            this.datasetCreationDate = x.datasetCreationDate
            this.datasetDescription = x.datasetDescription
            this.datasetId = x.datasetId
            this.datasetLastUpdateDate = x.datasetLastUpdateDate
            this.datasetName = x.datasetName
            this.datasetSource = x.datasetSource
            this.datasetStatus = x.datasetStatus
            this.datasetVersion = x.datasetVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetResponse = DescribeDatasetResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.DatasetSource] inside the given [block]
         */
        public fun datasetSource(block: aws.sdk.kotlin.services.iotsitewise.model.DatasetSource.Builder.() -> kotlin.Unit) {
            this.datasetSource = aws.sdk.kotlin.services.iotsitewise.model.DatasetSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus] inside the given [block]
         */
        public fun datasetStatus(block: aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus.Builder.() -> kotlin.Unit) {
            this.datasetStatus = aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (datasetArn == null) datasetArn = ""
            if (datasetCreationDate == null) datasetCreationDate = Instant.fromEpochSeconds(0)
            if (datasetDescription == null) datasetDescription = ""
            if (datasetId == null) datasetId = ""
            if (datasetLastUpdateDate == null) datasetLastUpdateDate = Instant.fromEpochSeconds(0)
            if (datasetName == null) datasetName = ""
            return this
        }
    }
}
