// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDashboardResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the dashboard, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}`
     */
    public val dashboardArn: kotlin.String = requireNotNull(builder.dashboardArn) { "A non-null value must be provided for dashboardArn" }
    /**
     * The date the dashboard was created, in Unix epoch time.
     */
    public val dashboardCreationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.dashboardCreationDate) { "A non-null value must be provided for dashboardCreationDate" }
    /**
     * The dashboard's definition JSON literal. For detailed information, see [Creating dashboards (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html) in the *IoT SiteWise User Guide*.
     */
    public val dashboardDefinition: kotlin.String = requireNotNull(builder.dashboardDefinition) { "A non-null value must be provided for dashboardDefinition" }
    /**
     * The dashboard's description.
     */
    public val dashboardDescription: kotlin.String? = builder.dashboardDescription
    /**
     * The ID of the dashboard.
     */
    public val dashboardId: kotlin.String = requireNotNull(builder.dashboardId) { "A non-null value must be provided for dashboardId" }
    /**
     * The date the dashboard was last updated, in Unix epoch time.
     */
    public val dashboardLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.dashboardLastUpdateDate) { "A non-null value must be provided for dashboardLastUpdateDate" }
    /**
     * The name of the dashboard.
     */
    public val dashboardName: kotlin.String = requireNotNull(builder.dashboardName) { "A non-null value must be provided for dashboardName" }
    /**
     * The ID of the project that the dashboard is in.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDashboardResponse(")
        append("dashboardArn=$dashboardArn,")
        append("dashboardCreationDate=$dashboardCreationDate,")
        append("dashboardDefinition=$dashboardDefinition,")
        append("dashboardDescription=$dashboardDescription,")
        append("dashboardId=$dashboardId,")
        append("dashboardLastUpdateDate=$dashboardLastUpdateDate,")
        append("dashboardName=$dashboardName,")
        append("projectId=$projectId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashboardArn.hashCode()
        result = 31 * result + (dashboardCreationDate.hashCode())
        result = 31 * result + (dashboardDefinition.hashCode())
        result = 31 * result + (dashboardDescription?.hashCode() ?: 0)
        result = 31 * result + (dashboardId.hashCode())
        result = 31 * result + (dashboardLastUpdateDate.hashCode())
        result = 31 * result + (dashboardName.hashCode())
        result = 31 * result + (projectId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDashboardResponse

        if (dashboardArn != other.dashboardArn) return false
        if (dashboardCreationDate != other.dashboardCreationDate) return false
        if (dashboardDefinition != other.dashboardDefinition) return false
        if (dashboardDescription != other.dashboardDescription) return false
        if (dashboardId != other.dashboardId) return false
        if (dashboardLastUpdateDate != other.dashboardLastUpdateDate) return false
        if (dashboardName != other.dashboardName) return false
        if (projectId != other.projectId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the dashboard, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}`
         */
        public var dashboardArn: kotlin.String? = null
        /**
         * The date the dashboard was created, in Unix epoch time.
         */
        public var dashboardCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The dashboard's definition JSON literal. For detailed information, see [Creating dashboards (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html) in the *IoT SiteWise User Guide*.
         */
        public var dashboardDefinition: kotlin.String? = null
        /**
         * The dashboard's description.
         */
        public var dashboardDescription: kotlin.String? = null
        /**
         * The ID of the dashboard.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * The date the dashboard was last updated, in Unix epoch time.
         */
        public var dashboardLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the dashboard.
         */
        public var dashboardName: kotlin.String? = null
        /**
         * The ID of the project that the dashboard is in.
         */
        public var projectId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse) : this() {
            this.dashboardArn = x.dashboardArn
            this.dashboardCreationDate = x.dashboardCreationDate
            this.dashboardDefinition = x.dashboardDefinition
            this.dashboardDescription = x.dashboardDescription
            this.dashboardId = x.dashboardId
            this.dashboardLastUpdateDate = x.dashboardLastUpdateDate
            this.dashboardName = x.dashboardName
            this.projectId = x.projectId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse = DescribeDashboardResponse(this)

        internal fun correctErrors(): Builder {
            if (dashboardArn == null) dashboardArn = ""
            if (dashboardCreationDate == null) dashboardCreationDate = Instant.fromEpochSeconds(0)
            if (dashboardDefinition == null) dashboardDefinition = ""
            if (dashboardId == null) dashboardId = ""
            if (dashboardLastUpdateDate == null) dashboardLastUpdateDate = Instant.fromEpochSeconds(0)
            if (dashboardName == null) dashboardName = ""
            if (projectId == null) projectId = ""
            return this
        }
    }
}
