// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeAssetPropertyResponse private constructor(builder: Builder) {
    /**
     * The external ID of the asset. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val assetExternalId: kotlin.String? = builder.assetExternalId
    /**
     * The ID of the asset, in UUID format.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The ID of the asset model, in UUID format.
     */
    public val assetModelId: kotlin.String = requireNotNull(builder.assetModelId) { "A non-null value must be provided for assetModelId" }
    /**
     * The name of the asset.
     */
    public val assetName: kotlin.String = requireNotNull(builder.assetName) { "A non-null value must be provided for assetName" }
    /**
     * The asset property's definition, alias, and notification state.
     *
     * This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in `compositeModel`.
     */
    public val assetProperty: aws.sdk.kotlin.services.iotsitewise.model.Property? = builder.assetProperty
    /**
     * The composite model that declares this asset property, if this asset property exists in a composite model.
     */
    public val compositeModel: aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty? = builder.compositeModel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAssetPropertyResponse(")
        append("assetExternalId=$assetExternalId,")
        append("assetId=$assetId,")
        append("assetModelId=$assetModelId,")
        append("assetName=$assetName,")
        append("assetProperty=$assetProperty,")
        append("compositeModel=$compositeModel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetExternalId?.hashCode() ?: 0
        result = 31 * result + (assetId.hashCode())
        result = 31 * result + (assetModelId.hashCode())
        result = 31 * result + (assetName.hashCode())
        result = 31 * result + (assetProperty?.hashCode() ?: 0)
        result = 31 * result + (compositeModel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAssetPropertyResponse

        if (assetExternalId != other.assetExternalId) return false
        if (assetId != other.assetId) return false
        if (assetModelId != other.assetModelId) return false
        if (assetName != other.assetName) return false
        if (assetProperty != other.assetProperty) return false
        if (compositeModel != other.compositeModel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The external ID of the asset. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var assetExternalId: kotlin.String? = null
        /**
         * The ID of the asset, in UUID format.
         */
        public var assetId: kotlin.String? = null
        /**
         * The ID of the asset model, in UUID format.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * The name of the asset.
         */
        public var assetName: kotlin.String? = null
        /**
         * The asset property's definition, alias, and notification state.
         *
         * This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in `compositeModel`.
         */
        public var assetProperty: aws.sdk.kotlin.services.iotsitewise.model.Property? = null
        /**
         * The composite model that declares this asset property, if this asset property exists in a composite model.
         */
        public var compositeModel: aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse) : this() {
            this.assetExternalId = x.assetExternalId
            this.assetId = x.assetId
            this.assetModelId = x.assetModelId
            this.assetName = x.assetName
            this.assetProperty = x.assetProperty
            this.compositeModel = x.compositeModel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse = DescribeAssetPropertyResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Property] inside the given [block]
         */
        public fun assetProperty(block: aws.sdk.kotlin.services.iotsitewise.model.Property.Builder.() -> kotlin.Unit) {
            this.assetProperty = aws.sdk.kotlin.services.iotsitewise.model.Property.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty] inside the given [block]
         */
        public fun compositeModel(block: aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty.Builder.() -> kotlin.Unit) {
            this.compositeModel = aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (assetModelId == null) assetModelId = ""
            if (assetName == null) assetName = ""
            return this
        }
    }
}
