// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeAssetModelResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset model, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}`
     */
    public val assetModelArn: kotlin.String = requireNotNull(builder.assetModelArn) { "A non-null value must be provided for assetModelArn" }
    /**
     * The list of the immediate child custom composite model summaries for the asset model.
     */
    public val assetModelCompositeModelSummaries: List<AssetModelCompositeModelSummary>? = builder.assetModelCompositeModelSummaries
    /**
     * The list of built-in composite models for the asset model, such as those with those of type `AWS/ALARMS`.
     */
    public val assetModelCompositeModels: List<AssetModelCompositeModel>? = builder.assetModelCompositeModels
    /**
     * The date the asset model was created, in Unix epoch time.
     */
    public val assetModelCreationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.assetModelCreationDate) { "A non-null value must be provided for assetModelCreationDate" }
    /**
     * The asset model's description.
     */
    public val assetModelDescription: kotlin.String = requireNotNull(builder.assetModelDescription) { "A non-null value must be provided for assetModelDescription" }
    /**
     * The external ID of the asset model, if any.
     */
    public val assetModelExternalId: kotlin.String? = builder.assetModelExternalId
    /**
     * A list of asset model hierarchies that each contain a `childAssetModelId` and a `hierarchyId` (named `id`). A hierarchy specifies allowed parent/child asset relationships for an asset model.
     */
    public val assetModelHierarchies: List<AssetModelHierarchy> = requireNotNull(builder.assetModelHierarchies) { "A non-null value must be provided for assetModelHierarchies" }
    /**
     * The ID of the asset model, in UUID format.
     */
    public val assetModelId: kotlin.String = requireNotNull(builder.assetModelId) { "A non-null value must be provided for assetModelId" }
    /**
     * The date the asset model was last updated, in Unix epoch time.
     */
    public val assetModelLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.assetModelLastUpdateDate) { "A non-null value must be provided for assetModelLastUpdateDate" }
    /**
     * The name of the asset model.
     */
    public val assetModelName: kotlin.String = requireNotNull(builder.assetModelName) { "A non-null value must be provided for assetModelName" }
    /**
     * The list of asset properties for the asset model.
     *
     * This object doesn't include properties that you define in composite models. You can find composite model properties in the `assetModelCompositeModels` object.
     */
    public val assetModelProperties: List<AssetModelProperty> = requireNotNull(builder.assetModelProperties) { "A non-null value must be provided for assetModelProperties" }
    /**
     * The current status of the asset model, which contains a state and any error message.
     */
    public val assetModelStatus: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus? = builder.assetModelStatus
    /**
     * The type of asset model.
     * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
     * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
     */
    public val assetModelType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelType? = builder.assetModelType
    /**
     * The version of the asset model. See [ Asset model versions](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelVersion: kotlin.String? = builder.assetModelVersion
    /**
     * The entity tag (ETag) is a hash of the retrieved version of the asset model. It's used to make concurrent updates safely to the resource. See [Optimistic locking for asset model writes](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html) in the *IoT SiteWise User Guide*.
     *
     * See [ Optimistic locking for asset model writes](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html) in the *IoT SiteWise User Guide*.
     */
    public val eTag: kotlin.String? = builder.eTag

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAssetModelResponse(")
        append("assetModelArn=$assetModelArn,")
        append("assetModelCompositeModelSummaries=$assetModelCompositeModelSummaries,")
        append("assetModelCompositeModels=$assetModelCompositeModels,")
        append("assetModelCreationDate=$assetModelCreationDate,")
        append("assetModelDescription=$assetModelDescription,")
        append("assetModelExternalId=$assetModelExternalId,")
        append("assetModelHierarchies=$assetModelHierarchies,")
        append("assetModelId=$assetModelId,")
        append("assetModelLastUpdateDate=$assetModelLastUpdateDate,")
        append("assetModelName=$assetModelName,")
        append("assetModelProperties=$assetModelProperties,")
        append("assetModelStatus=$assetModelStatus,")
        append("assetModelType=$assetModelType,")
        append("assetModelVersion=$assetModelVersion,")
        append("eTag=$eTag")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelArn.hashCode()
        result = 31 * result + (assetModelCompositeModelSummaries?.hashCode() ?: 0)
        result = 31 * result + (assetModelCompositeModels?.hashCode() ?: 0)
        result = 31 * result + (assetModelCreationDate.hashCode())
        result = 31 * result + (assetModelDescription.hashCode())
        result = 31 * result + (assetModelExternalId?.hashCode() ?: 0)
        result = 31 * result + (assetModelHierarchies.hashCode())
        result = 31 * result + (assetModelId.hashCode())
        result = 31 * result + (assetModelLastUpdateDate.hashCode())
        result = 31 * result + (assetModelName.hashCode())
        result = 31 * result + (assetModelProperties.hashCode())
        result = 31 * result + (assetModelStatus?.hashCode() ?: 0)
        result = 31 * result + (assetModelType?.hashCode() ?: 0)
        result = 31 * result + (assetModelVersion?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAssetModelResponse

        if (assetModelArn != other.assetModelArn) return false
        if (assetModelCompositeModelSummaries != other.assetModelCompositeModelSummaries) return false
        if (assetModelCompositeModels != other.assetModelCompositeModels) return false
        if (assetModelCreationDate != other.assetModelCreationDate) return false
        if (assetModelDescription != other.assetModelDescription) return false
        if (assetModelExternalId != other.assetModelExternalId) return false
        if (assetModelHierarchies != other.assetModelHierarchies) return false
        if (assetModelId != other.assetModelId) return false
        if (assetModelLastUpdateDate != other.assetModelLastUpdateDate) return false
        if (assetModelName != other.assetModelName) return false
        if (assetModelProperties != other.assetModelProperties) return false
        if (assetModelStatus != other.assetModelStatus) return false
        if (assetModelType != other.assetModelType) return false
        if (assetModelVersion != other.assetModelVersion) return false
        if (eTag != other.eTag) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset model, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}`
         */
        public var assetModelArn: kotlin.String? = null
        /**
         * The list of the immediate child custom composite model summaries for the asset model.
         */
        public var assetModelCompositeModelSummaries: List<AssetModelCompositeModelSummary>? = null
        /**
         * The list of built-in composite models for the asset model, such as those with those of type `AWS/ALARMS`.
         */
        public var assetModelCompositeModels: List<AssetModelCompositeModel>? = null
        /**
         * The date the asset model was created, in Unix epoch time.
         */
        public var assetModelCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The asset model's description.
         */
        public var assetModelDescription: kotlin.String? = null
        /**
         * The external ID of the asset model, if any.
         */
        public var assetModelExternalId: kotlin.String? = null
        /**
         * A list of asset model hierarchies that each contain a `childAssetModelId` and a `hierarchyId` (named `id`). A hierarchy specifies allowed parent/child asset relationships for an asset model.
         */
        public var assetModelHierarchies: List<AssetModelHierarchy>? = null
        /**
         * The ID of the asset model, in UUID format.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * The date the asset model was last updated, in Unix epoch time.
         */
        public var assetModelLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the asset model.
         */
        public var assetModelName: kotlin.String? = null
        /**
         * The list of asset properties for the asset model.
         *
         * This object doesn't include properties that you define in composite models. You can find composite model properties in the `assetModelCompositeModels` object.
         */
        public var assetModelProperties: List<AssetModelProperty>? = null
        /**
         * The current status of the asset model, which contains a state and any error message.
         */
        public var assetModelStatus: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus? = null
        /**
         * The type of asset model.
         * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
         * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
         */
        public var assetModelType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelType? = null
        /**
         * The version of the asset model. See [ Asset model versions](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelVersion: kotlin.String? = null
        /**
         * The entity tag (ETag) is a hash of the retrieved version of the asset model. It's used to make concurrent updates safely to the resource. See [Optimistic locking for asset model writes](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html) in the *IoT SiteWise User Guide*.
         *
         * See [ Optimistic locking for asset model writes](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html) in the *IoT SiteWise User Guide*.
         */
        public var eTag: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse) : this() {
            this.assetModelArn = x.assetModelArn
            this.assetModelCompositeModelSummaries = x.assetModelCompositeModelSummaries
            this.assetModelCompositeModels = x.assetModelCompositeModels
            this.assetModelCreationDate = x.assetModelCreationDate
            this.assetModelDescription = x.assetModelDescription
            this.assetModelExternalId = x.assetModelExternalId
            this.assetModelHierarchies = x.assetModelHierarchies
            this.assetModelId = x.assetModelId
            this.assetModelLastUpdateDate = x.assetModelLastUpdateDate
            this.assetModelName = x.assetModelName
            this.assetModelProperties = x.assetModelProperties
            this.assetModelStatus = x.assetModelStatus
            this.assetModelType = x.assetModelType
            this.assetModelVersion = x.assetModelVersion
            this.eTag = x.eTag
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse = DescribeAssetModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus] inside the given [block]
         */
        public fun assetModelStatus(block: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus.Builder.() -> kotlin.Unit) {
            this.assetModelStatus = aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assetModelArn == null) assetModelArn = ""
            if (assetModelCreationDate == null) assetModelCreationDate = Instant.fromEpochSeconds(0)
            if (assetModelDescription == null) assetModelDescription = ""
            if (assetModelHierarchies == null) assetModelHierarchies = emptyList()
            if (assetModelId == null) assetModelId = ""
            if (assetModelLastUpdateDate == null) assetModelLastUpdateDate = Instant.fromEpochSeconds(0)
            if (assetModelName == null) assetModelName = ""
            if (assetModelProperties == null) assetModelProperties = emptyList()
            return this
        }
    }
}
