// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a customer managed Amazon S3 bucket.
 */
public class CustomerManagedS3Storage private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see [Amazon S3 resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val s3ResourceArn: kotlin.String = requireNotNull(builder.s3ResourceArn) { "A non-null value must be provided for s3ResourceArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CustomerManagedS3Storage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerManagedS3Storage(")
        append("roleArn=$roleArn,")
        append("s3ResourceArn=$s3ResourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn.hashCode()
        result = 31 * result + (s3ResourceArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomerManagedS3Storage

        if (roleArn != other.roleArn) return false
        if (s3ResourceArn != other.s3ResourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CustomerManagedS3Storage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see [Amazon S3 resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var s3ResourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CustomerManagedS3Storage) : this() {
            this.roleArn = x.roleArn
            this.s3ResourceArn = x.s3ResourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CustomerManagedS3Storage = CustomerManagedS3Storage(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (s3ResourceArn == null) s3ResourceArn = ""
            return this
        }
    }
}
