// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePortalRequest private constructor(builder: Builder) {
    /**
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see [Monitoring with alarms](https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html) in the *IoT SiteWise Application Guide*.
     */
    public val alarms: aws.sdk.kotlin.services.iotsitewise.model.Alarms? = builder.alarms
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The email address that sends alarm notifications.
     *
     * If you use the [IoT Events managed Lambda function](https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html) to manage your emails, you must [verify the sender email address in Amazon SES](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
     */
    public val notificationSenderEmail: kotlin.String? = builder.notificationSenderEmail
    /**
     * The service to use to authenticate users to the portal. Choose from the following options:
     * + `SSO` – The portal uses IAM Identity Center to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center, you must enable IAM Identity Center. For more information, see [Enabling IAM Identity Center](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso) in the *IoT SiteWise User Guide*. This option is only available in Amazon Web Services Regions other than the China Regions.
     * + `IAM` – The portal uses Identity and Access Management to authenticate users and manage user permissions.
     *
     * You can't change this value after you create a portal.
     *
     * Default: `SSO`
     */
    public val portalAuthMode: aws.sdk.kotlin.services.iotsitewise.model.AuthMode? = builder.portalAuthMode
    /**
     * The Amazon Web Services administrator's contact email address.
     */
    public val portalContactEmail: kotlin.String? = builder.portalContactEmail
    /**
     * A description for the portal.
     */
    public val portalDescription: kotlin.String? = builder.portalDescription
    /**
     * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background.
     */
    public val portalLogoImageFile: aws.sdk.kotlin.services.iotsitewise.model.ImageFile? = builder.portalLogoImageFile
    /**
     * A friendly name for the portal.
     */
    public val portalName: kotlin.String? = builder.portalName
    /**
     * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is `SITEWISE_PORTAL_V1`. The value for IoT SiteWise Monitor (AI-aware) is `SITEWISE_PORTAL_V2`.
     */
    public val portalType: aws.sdk.kotlin.services.iotsitewise.model.PortalType? = builder.portalType
    /**
     * The configuration entry associated with the specific portal type. The value for IoT SiteWise Monitor (Classic) is `SITEWISE_PORTAL_V1`. The value for IoT SiteWise Monitor (AI-aware) is `SITEWISE_PORTAL_V2`.
     */
    public val portalTypeConfiguration: Map<String, PortalTypeEntry>? = builder.portalTypeConfiguration
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see [Using service roles for IoT SiteWise Monitor](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html) in the *IoT SiteWise User Guide*.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of key-value pairs that contain metadata for the portal. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreatePortalRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePortalRequest(")
        append("alarms=$alarms,")
        append("clientToken=$clientToken,")
        append("notificationSenderEmail=*** Sensitive Data Redacted ***,")
        append("portalAuthMode=$portalAuthMode,")
        append("portalContactEmail=*** Sensitive Data Redacted ***,")
        append("portalDescription=$portalDescription,")
        append("portalLogoImageFile=$portalLogoImageFile,")
        append("portalName=$portalName,")
        append("portalType=$portalType,")
        append("portalTypeConfiguration=$portalTypeConfiguration,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (notificationSenderEmail?.hashCode() ?: 0)
        result = 31 * result + (portalAuthMode?.hashCode() ?: 0)
        result = 31 * result + (portalContactEmail?.hashCode() ?: 0)
        result = 31 * result + (portalDescription?.hashCode() ?: 0)
        result = 31 * result + (portalLogoImageFile?.hashCode() ?: 0)
        result = 31 * result + (portalName?.hashCode() ?: 0)
        result = 31 * result + (portalType?.hashCode() ?: 0)
        result = 31 * result + (portalTypeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePortalRequest

        if (alarms != other.alarms) return false
        if (clientToken != other.clientToken) return false
        if (notificationSenderEmail != other.notificationSenderEmail) return false
        if (portalAuthMode != other.portalAuthMode) return false
        if (portalContactEmail != other.portalContactEmail) return false
        if (portalDescription != other.portalDescription) return false
        if (portalLogoImageFile != other.portalLogoImageFile) return false
        if (portalName != other.portalName) return false
        if (portalType != other.portalType) return false
        if (portalTypeConfiguration != other.portalTypeConfiguration) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreatePortalRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see [Monitoring with alarms](https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html) in the *IoT SiteWise Application Guide*.
         */
        public var alarms: aws.sdk.kotlin.services.iotsitewise.model.Alarms? = null
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The email address that sends alarm notifications.
         *
         * If you use the [IoT Events managed Lambda function](https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html) to manage your emails, you must [verify the sender email address in Amazon SES](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
         */
        public var notificationSenderEmail: kotlin.String? = null
        /**
         * The service to use to authenticate users to the portal. Choose from the following options:
         * + `SSO` – The portal uses IAM Identity Center to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center, you must enable IAM Identity Center. For more information, see [Enabling IAM Identity Center](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso) in the *IoT SiteWise User Guide*. This option is only available in Amazon Web Services Regions other than the China Regions.
         * + `IAM` – The portal uses Identity and Access Management to authenticate users and manage user permissions.
         *
         * You can't change this value after you create a portal.
         *
         * Default: `SSO`
         */
        public var portalAuthMode: aws.sdk.kotlin.services.iotsitewise.model.AuthMode? = null
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        public var portalContactEmail: kotlin.String? = null
        /**
         * A description for the portal.
         */
        public var portalDescription: kotlin.String? = null
        /**
         * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background.
         */
        public var portalLogoImageFile: aws.sdk.kotlin.services.iotsitewise.model.ImageFile? = null
        /**
         * A friendly name for the portal.
         */
        public var portalName: kotlin.String? = null
        /**
         * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is `SITEWISE_PORTAL_V1`. The value for IoT SiteWise Monitor (AI-aware) is `SITEWISE_PORTAL_V2`.
         */
        public var portalType: aws.sdk.kotlin.services.iotsitewise.model.PortalType? = null
        /**
         * The configuration entry associated with the specific portal type. The value for IoT SiteWise Monitor (Classic) is `SITEWISE_PORTAL_V1`. The value for IoT SiteWise Monitor (AI-aware) is `SITEWISE_PORTAL_V2`.
         */
        public var portalTypeConfiguration: Map<String, PortalTypeEntry>? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see [Using service roles for IoT SiteWise Monitor](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html) in the *IoT SiteWise User Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of key-value pairs that contain metadata for the portal. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreatePortalRequest) : this() {
            this.alarms = x.alarms
            this.clientToken = x.clientToken
            this.notificationSenderEmail = x.notificationSenderEmail
            this.portalAuthMode = x.portalAuthMode
            this.portalContactEmail = x.portalContactEmail
            this.portalDescription = x.portalDescription
            this.portalLogoImageFile = x.portalLogoImageFile
            this.portalName = x.portalName
            this.portalType = x.portalType
            this.portalTypeConfiguration = x.portalTypeConfiguration
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreatePortalRequest = CreatePortalRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Alarms] inside the given [block]
         */
        public fun alarms(block: aws.sdk.kotlin.services.iotsitewise.model.Alarms.Builder.() -> kotlin.Unit) {
            this.alarms = aws.sdk.kotlin.services.iotsitewise.model.Alarms.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ImageFile] inside the given [block]
         */
        public fun portalLogoImageFile(block: aws.sdk.kotlin.services.iotsitewise.model.ImageFile.Builder.() -> kotlin.Unit) {
            this.portalLogoImageFile = aws.sdk.kotlin.services.iotsitewise.model.ImageFile.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
