// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGatewayRequest private constructor(builder: Builder) {
    /**
     * A unique name for the gateway.
     */
    public val gatewayName: kotlin.String? = builder.gatewayName
    /**
     * The gateway's platform. You can only specify one platform in a gateway.
     */
    public val gatewayPlatform: aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform? = builder.gatewayPlatform
    /**
     * The version of the gateway to create. Specify `3` to create an MQTT-enabled, V3 gateway and `2` to create a Classic streams, V2 gateway. If not specified, the default is `2` (Classic streams, V2 gateway).
     *
     * When creating a V3 gateway (`gatewayVersion=3`) with the `GreengrassV2` platform, you must also specify the `coreDeviceOperatingSystem` parameter.
     *
     *  We recommend creating an MQTT-enabled gateway for self-hosted gateways and Siemens Industrial Edge gateways. For more information on gateway versions, see [Use Amazon Web Services IoT SiteWise Edge Edge gateways](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateways.html).
     */
    public val gatewayVersion: kotlin.String? = builder.gatewayVersion
    /**
     * A list of key-value pairs that contain metadata for the gateway. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreateGatewayRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGatewayRequest(")
        append("gatewayName=$gatewayName,")
        append("gatewayPlatform=$gatewayPlatform,")
        append("gatewayVersion=$gatewayVersion,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayName?.hashCode() ?: 0
        result = 31 * result + (gatewayPlatform?.hashCode() ?: 0)
        result = 31 * result + (gatewayVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGatewayRequest

        if (gatewayName != other.gatewayName) return false
        if (gatewayPlatform != other.gatewayPlatform) return false
        if (gatewayVersion != other.gatewayVersion) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreateGatewayRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique name for the gateway.
         */
        public var gatewayName: kotlin.String? = null
        /**
         * The gateway's platform. You can only specify one platform in a gateway.
         */
        public var gatewayPlatform: aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform? = null
        /**
         * The version of the gateway to create. Specify `3` to create an MQTT-enabled, V3 gateway and `2` to create a Classic streams, V2 gateway. If not specified, the default is `2` (Classic streams, V2 gateway).
         *
         * When creating a V3 gateway (`gatewayVersion=3`) with the `GreengrassV2` platform, you must also specify the `coreDeviceOperatingSystem` parameter.
         *
         *  We recommend creating an MQTT-enabled gateway for self-hosted gateways and Siemens Industrial Edge gateways. For more information on gateway versions, see [Use Amazon Web Services IoT SiteWise Edge Edge gateways](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateways.html).
         */
        public var gatewayVersion: kotlin.String? = null
        /**
         * A list of key-value pairs that contain metadata for the gateway. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreateGatewayRequest) : this() {
            this.gatewayName = x.gatewayName
            this.gatewayPlatform = x.gatewayPlatform
            this.gatewayVersion = x.gatewayVersion
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreateGatewayRequest = CreateGatewayRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform] inside the given [block]
         */
        public fun gatewayPlatform(block: aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform.Builder.() -> kotlin.Unit) {
            this.gatewayPlatform = aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
