// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateComputationModelResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the computation model, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}`
     */
    public val computationModelArn: kotlin.String = requireNotNull(builder.computationModelArn) { "A non-null value must be provided for computationModelArn" }
    /**
     * The ID of the computation model.
     */
    public val computationModelId: kotlin.String = requireNotNull(builder.computationModelId) { "A non-null value must be provided for computationModelId" }
    /**
     * The status of the computation model, containing a state (CREATING after successfully calling this operation) and any error messages.
     */
    public val computationModelStatus: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus? = builder.computationModelStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreateComputationModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComputationModelResponse(")
        append("computationModelArn=$computationModelArn,")
        append("computationModelId=$computationModelId,")
        append("computationModelStatus=$computationModelStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computationModelArn.hashCode()
        result = 31 * result + (computationModelId.hashCode())
        result = 31 * result + (computationModelStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateComputationModelResponse

        if (computationModelArn != other.computationModelArn) return false
        if (computationModelId != other.computationModelId) return false
        if (computationModelStatus != other.computationModelStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreateComputationModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the computation model, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}`
         */
        public var computationModelArn: kotlin.String? = null
        /**
         * The ID of the computation model.
         */
        public var computationModelId: kotlin.String? = null
        /**
         * The status of the computation model, containing a state (CREATING after successfully calling this operation) and any error messages.
         */
        public var computationModelStatus: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreateComputationModelResponse) : this() {
            this.computationModelArn = x.computationModelArn
            this.computationModelId = x.computationModelId
            this.computationModelStatus = x.computationModelStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreateComputationModelResponse = CreateComputationModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus] inside the given [block]
         */
        public fun computationModelStatus(block: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus.Builder.() -> kotlin.Unit) {
            this.computationModelStatus = aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (computationModelArn == null) computationModelArn = ""
            if (computationModelId == null) computationModelId = ""
            return this
        }
    }
}
