// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAccessPolicyRequest private constructor(builder: Builder) {
    /**
     * The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.
     */
    public val accessPolicyIdentity: aws.sdk.kotlin.services.iotsitewise.model.Identity? = builder.accessPolicyIdentity
    /**
     * The permission level for this access policy. Note that a project `ADMINISTRATOR` is also known as a project owner.
     */
    public val accessPolicyPermission: aws.sdk.kotlin.services.iotsitewise.model.Permission? = builder.accessPolicyPermission
    /**
     * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     */
    public val accessPolicyResource: aws.sdk.kotlin.services.iotsitewise.model.Resource? = builder.accessPolicyResource
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A list of key-value pairs that contain metadata for the access policy. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreateAccessPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPolicyRequest(")
        append("accessPolicyIdentity=$accessPolicyIdentity,")
        append("accessPolicyPermission=$accessPolicyPermission,")
        append("accessPolicyResource=$accessPolicyResource,")
        append("clientToken=$clientToken,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicyIdentity?.hashCode() ?: 0
        result = 31 * result + (accessPolicyPermission?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyResource?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessPolicyRequest

        if (accessPolicyIdentity != other.accessPolicyIdentity) return false
        if (accessPolicyPermission != other.accessPolicyPermission) return false
        if (accessPolicyResource != other.accessPolicyResource) return false
        if (clientToken != other.clientToken) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreateAccessPolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.
         */
        public var accessPolicyIdentity: aws.sdk.kotlin.services.iotsitewise.model.Identity? = null
        /**
         * The permission level for this access policy. Note that a project `ADMINISTRATOR` is also known as a project owner.
         */
        public var accessPolicyPermission: aws.sdk.kotlin.services.iotsitewise.model.Permission? = null
        /**
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         */
        public var accessPolicyResource: aws.sdk.kotlin.services.iotsitewise.model.Resource? = null
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A list of key-value pairs that contain metadata for the access policy. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreateAccessPolicyRequest) : this() {
            this.accessPolicyIdentity = x.accessPolicyIdentity
            this.accessPolicyPermission = x.accessPolicyPermission
            this.accessPolicyResource = x.accessPolicyResource
            this.clientToken = x.clientToken
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreateAccessPolicyRequest = CreateAccessPolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Identity] inside the given [block]
         */
        public fun accessPolicyIdentity(block: aws.sdk.kotlin.services.iotsitewise.model.Identity.Builder.() -> kotlin.Unit) {
            this.accessPolicyIdentity = aws.sdk.kotlin.services.iotsitewise.model.Identity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Resource] inside the given [block]
         */
        public fun accessPolicyResource(block: aws.sdk.kotlin.services.iotsitewise.model.Resource.Builder.() -> kotlin.Unit) {
            this.accessPolicyResource = aws.sdk.kotlin.services.iotsitewise.model.Resource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
