// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information for an asset property value entry that is associated with the [BatchGetAssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html) API.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 */
public class BatchGetAssetPropertyValueEntry private constructor(builder: Builder) {
    /**
     * The ID of the asset in which the asset property was created.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The ID of the entry.
     */
    public val entryId: kotlin.String = requireNotNull(builder.entryId) { "A non-null value must be provided for entryId" }
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     */
    public val propertyAlias: kotlin.String? = builder.propertyAlias
    /**
     * The ID of the asset property, in UUID format.
     */
    public val propertyId: kotlin.String? = builder.propertyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetAssetPropertyValueEntry(")
        append("assetId=$assetId,")
        append("entryId=$entryId,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (entryId.hashCode())
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetAssetPropertyValueEntry

        if (assetId != other.assetId) return false
        if (entryId != other.entryId) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset in which the asset property was created.
         */
        public var assetId: kotlin.String? = null
        /**
         * The ID of the entry.
         */
        public var entryId: kotlin.String? = null
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         */
        public var propertyAlias: kotlin.String? = null
        /**
         * The ID of the asset property, in UUID format.
         */
        public var propertyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueEntry) : this() {
            this.assetId = x.assetId
            this.entryId = x.entryId
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueEntry = BatchGetAssetPropertyValueEntry(this)

        internal fun correctErrors(): Builder {
            if (entryId == null) entryId = ""
            return this
        }
    }
}
