// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a summary of a property associated with an asset.
 */
public class AssetPropertySummary private constructor(builder: Builder) {
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The ID of the composite model that contains the asset property.
     */
    public val assetCompositeModelId: kotlin.String? = builder.assetCompositeModelId
    /**
     * The external ID of the property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the property.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Contains asset property value notification information. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see [Interacting with other services](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html) in the *IoT SiteWise User Guide*.
     */
    public val notification: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification? = builder.notification
    /**
     * The structured path to the property from the root of the asset.
     */
    public val path: List<AssetPropertyPathSegment>? = builder.path
    /**
     * The unit of measure (such as Newtons or RPM) of the asset property.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetPropertySummary(")
        append("alias=$alias,")
        append("assetCompositeModelId=$assetCompositeModelId,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("notification=$notification,")
        append("path=$path,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (assetCompositeModelId?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetPropertySummary

        if (alias != other.alias) return false
        if (assetCompositeModelId != other.assetCompositeModelId) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (notification != other.notification) return false
        if (path != other.path) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         */
        public var alias: kotlin.String? = null
        /**
         * The ID of the composite model that contains the asset property.
         */
        public var assetCompositeModelId: kotlin.String? = null
        /**
         * The external ID of the property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the property.
         */
        public var id: kotlin.String? = null
        /**
         * Contains asset property value notification information. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see [Interacting with other services](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html) in the *IoT SiteWise User Guide*.
         */
        public var notification: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification? = null
        /**
         * The structured path to the property from the root of the asset.
         */
        public var path: List<AssetPropertyPathSegment>? = null
        /**
         * The unit of measure (such as Newtons or RPM) of the asset property.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetPropertySummary) : this() {
            this.alias = x.alias
            this.assetCompositeModelId = x.assetCompositeModelId
            this.externalId = x.externalId
            this.id = x.id
            this.notification = x.notification
            this.path = x.path
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertySummary = AssetPropertySummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            return this
        }
    }
}
