// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains asset property information.
 */
public class AssetProperty private constructor(builder: Builder) {
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The data type of the asset property.
     */
    public val dataType: aws.sdk.kotlin.services.iotsitewise.model.PropertyDataType = requireNotNull(builder.dataType) { "A non-null value must be provided for dataType" }
    /**
     * The data type of the structure for this property. This parameter exists on properties that have the `STRUCT` data type.
     */
    public val dataTypeSpec: kotlin.String? = builder.dataTypeSpec
    /**
     * The external ID of the asset property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the asset property.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the property.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The asset property's notification topic and state. For more information, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
     */
    public val notification: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification? = builder.notification
    /**
     * The structured path to the property from the root of the asset.
     */
    public val path: List<AssetPropertyPathSegment>? = builder.path
    /**
     * The unit (such as `Newtons` or `RPM`) of the asset property.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetProperty = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetProperty(")
        append("alias=$alias,")
        append("dataType=$dataType,")
        append("dataTypeSpec=$dataTypeSpec,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("name=$name,")
        append("notification=$notification,")
        append("path=$path,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (dataType.hashCode())
        result = 31 * result + (dataTypeSpec?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetProperty

        if (alias != other.alias) return false
        if (dataType != other.dataType) return false
        if (dataTypeSpec != other.dataTypeSpec) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (notification != other.notification) return false
        if (path != other.path) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetProperty = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         */
        public var alias: kotlin.String? = null
        /**
         * The data type of the asset property.
         */
        public var dataType: aws.sdk.kotlin.services.iotsitewise.model.PropertyDataType? = null
        /**
         * The data type of the structure for this property. This parameter exists on properties that have the `STRUCT` data type.
         */
        public var dataTypeSpec: kotlin.String? = null
        /**
         * The external ID of the asset property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the asset property.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the property.
         */
        public var name: kotlin.String? = null
        /**
         * The asset property's notification topic and state. For more information, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
         */
        public var notification: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification? = null
        /**
         * The structured path to the property from the root of the asset.
         */
        public var path: List<AssetPropertyPathSegment>? = null
        /**
         * The unit (such as `Newtons` or `RPM`) of the asset property.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetProperty) : this() {
            this.alias = x.alias
            this.dataType = x.dataType
            this.dataTypeSpec = x.dataTypeSpec
            this.externalId = x.externalId
            this.id = x.id
            this.name = x.name
            this.notification = x.notification
            this.path = x.path
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetProperty = AssetProperty(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataType == null) dataType = PropertyDataType.SdkUnknown("no value provided")
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
