// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of an asset model.
 */
public class AssetModelSummary private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset model, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}`
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The type of asset model.
     * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
     * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
     */
    public val assetModelType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelType? = builder.assetModelType
    /**
     * The date the asset model was created, in Unix epoch time.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The asset model description.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The external ID of the asset model. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the asset model (used with IoT SiteWise API operations).
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date the asset model was last updated, in Unix epoch time.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateDate) { "A non-null value must be provided for lastUpdateDate" }
    /**
     * The name of the asset model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The current status of the asset model.
     */
    public val status: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus? = builder.status
    /**
     * The version number of the asset model.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelSummary(")
        append("arn=$arn,")
        append("assetModelType=$assetModelType,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("status=$status,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (assetModelType?.hashCode() ?: 0)
        result = 31 * result + (creationDate.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdateDate.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetModelSummary

        if (arn != other.arn) return false
        if (assetModelType != other.assetModelType) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetModelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset model, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}`
         */
        public var arn: kotlin.String? = null
        /**
         * The type of asset model.
         * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
         * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
         */
        public var assetModelType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelType? = null
        /**
         * The date the asset model was created, in Unix epoch time.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The asset model description.
         */
        public var description: kotlin.String? = null
        /**
         * The external ID of the asset model. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the asset model (used with IoT SiteWise API operations).
         */
        public var id: kotlin.String? = null
        /**
         * The date the asset model was last updated, in Unix epoch time.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the asset model.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the asset model.
         */
        public var status: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus? = null
        /**
         * The version number of the asset model.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetModelSummary) : this() {
            this.arn = x.arn
            this.assetModelType = x.assetModelType
            this.creationDate = x.creationDate
            this.description = x.description
            this.externalId = x.externalId
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.status = x.status
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetModelSummary = AssetModelSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (id == null) id = ""
            if (lastUpdateDate == null) lastUpdateDate = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
