// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a summary of the composite model for a specific asset.
 */
public class AssetCompositeModelSummary private constructor(builder: Builder) {
    /**
     * A description of the composite model that this summary describes.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * An external ID to assign to the asset model.
     *
     * If the composite model is a derived composite model, or one nested inside a component model, you can only set the external ID using `UpdateAssetModelCompositeModel` and specifying the derived ID of the model or property from the created model it's a part of.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the composite model that this summary describes.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the composite model that this summary describes.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The path that includes all the components of the asset model for the asset.
     */
    public val path: List<AssetCompositeModelPathSegment> = requireNotNull(builder.path) { "A non-null value must be provided for path" }
    /**
     * The type of asset model.
     * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
     * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetCompositeModelSummary(")
        append("description=$description,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("name=$name,")
        append("path=$path,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description.hashCode()
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (path.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetCompositeModelSummary

        if (description != other.description) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (path != other.path) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the composite model that this summary describes.
         */
        public var description: kotlin.String? = null
        /**
         * An external ID to assign to the asset model.
         *
         * If the composite model is a derived composite model, or one nested inside a component model, you can only set the external ID using `UpdateAssetModelCompositeModel` and specifying the derived ID of the model or property from the created model it's a part of.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the composite model that this summary describes.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the composite model that this summary describes.
         */
        public var name: kotlin.String? = null
        /**
         * The path that includes all the components of the asset model for the asset.
         */
        public var path: List<AssetCompositeModelPathSegment>? = null
        /**
         * The type of asset model.
         * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
         * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelSummary) : this() {
            this.description = x.description
            this.externalId = x.externalId
            this.id = x.id
            this.name = x.name
            this.path = x.path
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelSummary = AssetCompositeModelSummary(this)

        internal fun correctErrors(): Builder {
            if (description == null) description = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (path == null) path = emptyList()
            if (type == null) type = ""
            return this
        }
    }
}
