// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotsitewise.auth.DefaultIotSiteWiseAuthSchemeProvider
import aws.sdk.kotlin.services.iotsitewise.auth.IotSiteWiseAuthSchemeProvider
import aws.sdk.kotlin.services.iotsitewise.endpoints.DefaultIotSiteWiseEndpointProvider
import aws.sdk.kotlin.services.iotsitewise.endpoints.IotSiteWiseEndpointParameters
import aws.sdk.kotlin.services.iotsitewise.endpoints.IotSiteWiseEndpointProvider
import aws.sdk.kotlin.services.iotsitewise.model.AssociateAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.AssociateAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest
import aws.sdk.kotlin.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchAssociateProjectAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.BatchAssociateProjectAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueRequest
import aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueResponse
import aws.sdk.kotlin.services.iotsitewise.model.BatchPutAssetPropertyValueRequest
import aws.sdk.kotlin.services.iotsitewise.model.BatchPutAssetPropertyValueResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateAccessPolicyRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateAccessPolicyResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelCompositeModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateAssetRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateBulkImportJobRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateBulkImportJobResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateComputationModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateComputationModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateDashboardRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateDatasetRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateDatasetResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateGatewayRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateGatewayResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreatePortalRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.CreateProjectRequest
import aws.sdk.kotlin.services.iotsitewise.model.CreateProjectResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAccessPolicyRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAccessPolicyResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetModelCompositeModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetModelCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteComputationModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteComputationModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteDashboardRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteDatasetRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteDatasetResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteGatewayRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteGatewayResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeletePortalRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeletePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteProjectRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteProjectResponse
import aws.sdk.kotlin.services.iotsitewise.model.DeleteTimeSeriesRequest
import aws.sdk.kotlin.services.iotsitewise.model.DeleteTimeSeriesResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAccessPolicyRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAccessPolicyResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeActionRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeActionResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetCompositeModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelCompositeModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeBulkImportJobRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeBulkImportJobResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelExecutionSummaryRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelExecutionSummaryResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeLoggingOptionsRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeLoggingOptionsResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribePortalRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeStorageConfigurationRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeStorageConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeTimeSeriesRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeTimeSeriesResponse
import aws.sdk.kotlin.services.iotsitewise.model.DisassociateAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.DisassociateAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest
import aws.sdk.kotlin.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyResponse
import aws.sdk.kotlin.services.iotsitewise.model.ExecuteActionRequest
import aws.sdk.kotlin.services.iotsitewise.model.ExecuteActionResponse
import aws.sdk.kotlin.services.iotsitewise.model.ExecuteQueryRequest
import aws.sdk.kotlin.services.iotsitewise.model.ExecuteQueryResponse
import aws.sdk.kotlin.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
import aws.sdk.kotlin.services.iotsitewise.model.GetAssetPropertyAggregatesResponse
import aws.sdk.kotlin.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
import aws.sdk.kotlin.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse
import aws.sdk.kotlin.services.iotsitewise.model.GetAssetPropertyValueRequest
import aws.sdk.kotlin.services.iotsitewise.model.GetAssetPropertyValueResponse
import aws.sdk.kotlin.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
import aws.sdk.kotlin.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse
import aws.sdk.kotlin.services.iotsitewise.model.InvokeAssistantRequest
import aws.sdk.kotlin.services.iotsitewise.model.InvokeAssistantResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAccessPoliciesRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAccessPoliciesResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListActionsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListActionsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelCompositeModelsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelCompositeModelsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelPropertiesRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelPropertiesResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetModelsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetPropertiesResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetRelationshipsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetRelationshipsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListAssociatedAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListAssociatedAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListBulkImportJobsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListBulkImportJobsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListCompositionRelationshipsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListCompositionRelationshipsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListComputationModelDataBindingUsagesRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListComputationModelDataBindingUsagesResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListComputationModelResolveToResourcesRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListComputationModelResolveToResourcesResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListComputationModelsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListComputationModelsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListDashboardsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListDashboardsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListDatasetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListDatasetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListExecutionsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListExecutionsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListGatewaysRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListGatewaysResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListPortalsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListPortalsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListProjectAssetsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListProjectAssetsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListProjectsRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListProjectsResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotsitewise.model.ListTimeSeriesRequest
import aws.sdk.kotlin.services.iotsitewise.model.ListTimeSeriesResponse
import aws.sdk.kotlin.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest
import aws.sdk.kotlin.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.PutLoggingOptionsRequest
import aws.sdk.kotlin.services.iotsitewise.model.PutLoggingOptionsResponse
import aws.sdk.kotlin.services.iotsitewise.model.PutStorageConfigurationRequest
import aws.sdk.kotlin.services.iotsitewise.model.PutStorageConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.TagResourceRequest
import aws.sdk.kotlin.services.iotsitewise.model.TagResourceResponse
import aws.sdk.kotlin.services.iotsitewise.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotsitewise.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAccessPolicyRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAccessPolicyResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelCompositeModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateComputationModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateComputationModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateDashboardRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateDatasetRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateDatasetResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateGatewayRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateGatewayResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdatePortalRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdatePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.UpdateProjectRequest
import aws.sdk.kotlin.services.iotsitewise.model.UpdateProjectResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "IoTSiteWise"
public const val SdkVersion: String = "1.5.8"
public const val ServiceApiVersion: String = "2019-12-02"

/**
 * Welcome to the IoT SiteWise API Reference. IoT SiteWise is an Amazon Web Services service that connects [Industrial Internet of Things (IIoT)](https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications) devices to the power of the Amazon Web Services Cloud. For more information, see the [IoT SiteWise User Guide](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/). For information about IoT SiteWise quotas, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
 */
public interface IotSiteWiseClient : SdkClient {
    /**
     * IotSiteWiseClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotSiteWiseClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotSiteWise",
                "IOTSITEWISE",
                "iotsitewise",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotSiteWiseClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotSiteWiseClient = DefaultIotSiteWiseClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotSiteWiseEndpointProvider = builder.endpointProvider ?: DefaultIotSiteWiseEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotSiteWiseAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotSiteWiseAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoTSiteWise"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotSiteWiseEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotSiteWiseAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For more information, see [Associating assets](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun associateAssets(input: AssociateAssetsRequest): AssociateAssetsResponse

    /**
     * Associates a time series (data stream) with an asset property.
     */
    public suspend fun associateTimeSeriesToAssetProperty(input: AssociateTimeSeriesToAssetPropertyRequest): AssociateTimeSeriesToAssetPropertyResponse

    /**
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     */
    public suspend fun batchAssociateProjectAssets(input: BatchAssociateProjectAssetsRequest): BatchAssociateProjectAssetsResponse

    /**
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     */
    public suspend fun batchDisassociateProjectAssets(input: BatchDisassociateProjectAssetsRequest): BatchDisassociateProjectAssetsResponse

    /**
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more information, see [Querying aggregates](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates) in the *IoT SiteWise User Guide*.
     */
    public suspend fun batchGetAssetPropertyAggregates(input: BatchGetAssetPropertyAggregatesRequest): BatchGetAssetPropertyAggregatesResponse

    /**
     * Gets the current value for one or more asset properties. For more information, see [Querying current values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values) in the *IoT SiteWise User Guide*.
     */
    public suspend fun batchGetAssetPropertyValue(input: BatchGetAssetPropertyValueRequest): BatchGetAssetPropertyValueResponse

    /**
     * Gets the historical values for one or more asset properties. For more information, see [Querying historical values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values) in the *IoT SiteWise User Guide*.
     */
    public suspend fun batchGetAssetPropertyValueHistory(input: BatchGetAssetPropertyValueHistoryRequest): BatchGetAssetPropertyValueHistoryResponse

    /**
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point. For more information, see [Ingesting data using the API](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html) in the *IoT SiteWise User Guide*.
     *
     * To identify an asset property, you must specify one of the following:
     * + The `assetId` and `propertyId` of an asset property.
     * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
     *
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive range of &#91;-7 days, +10 minutes&#93; and returns a `TimestampOutOfRangeException` error.
     *
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a different quality. For example, if you store a TQV `{T1, GOOD, V1}`, then storing `{T1, GOOD, V2}` replaces the existing TQV.
     *
     * IoT SiteWise authorizes access to each `BatchPutAssetPropertyValue` entry individually. For more information, see [BatchPutAssetPropertyValue authorization](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action) in the *IoT SiteWise User Guide*.
     */
    public suspend fun batchPutAssetPropertyValue(input: BatchPutAssetPropertyValueRequest): BatchPutAssetPropertyValueResponse

    /**
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group, or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     */
    public suspend fun createAccessPolicy(input: CreateAccessPolicyRequest): CreateAccessPolicyResponse

    /**
     * Creates an asset from an existing asset model. For more information, see [Creating assets](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse

    /**
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models. With asset models, you can easily create assets of the same type that have standardized definitions. Each asset created from a model inherits the asset model's property and hierarchy definitions. For more information, see [Defining asset models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html) in the *IoT SiteWise User Guide*.
     *
     * You can create two types of asset models, `ASSET_MODEL` or `COMPONENT_MODEL`.
     * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
     * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
     */
    public suspend fun createAssetModel(input: CreateAssetModelRequest): CreateAssetModelResponse

    /**
     * Creates a custom composite model from specified property and hierarchy definitions. There are two types of custom composite models, `inline` and `component-model-based`.
     *
     * Use component-model-based custom composite models to define standard, reusable components. A component-model-based custom composite model consists of a name, a description, and the ID of the component model it references. A component-model-based custom composite model has no properties of its own; its referenced component model provides its associated properties to any created assets. For more information, see [Custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html) in the *IoT SiteWise User Guide*.
     *
     * Use inline custom composite models to organize the properties of an asset model. The properties of inline custom composite models are local to the asset model where they are included and can't be used to create multiple assets.
     *
     * To create a component-model-based model, specify the `composedAssetModelId` of an existing asset model with `assetModelType` of `COMPONENT_MODEL`.
     *
     * To create an inline model, specify the `assetModelCompositeModelProperties` and don't include an `composedAssetModelId`.
     */
    public suspend fun createAssetModelCompositeModel(input: CreateAssetModelCompositeModelRequest): CreateAssetModelCompositeModelResponse

    /**
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see [Create a bulk import job (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html) in the *Amazon Simple Storage Service User Guide*.
     *
     * Before you create a bulk import job, you must enable IoT SiteWise warm tier or IoT SiteWise cold tier. For more information about how to configure storage settings, see [PutStorageConfiguration](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html).
     *
     * Bulk import is designed to store historical data to IoT SiteWise.
     * + Newly ingested data in the hot tier triggers notifications and computations.
     * + After data moves from the hot tier to the warm or cold tier based on retention settings, it does not trigger computations or notifications.
     * + Data older than 7 days does not trigger computations or notifications.
     */
    public suspend fun createBulkImportJob(input: CreateBulkImportJobRequest): CreateBulkImportJobResponse

    /**
     * Create a computation model with a configuration and data binding.
     */
    public suspend fun createComputationModel(input: CreateComputationModelRequest): CreateComputationModelResponse

    /**
     * Creates a dashboard in an IoT SiteWise Monitor project.
     */
    public suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse

    /**
     * Creates a dataset to connect an external datasource.
     */
    public suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to IoT SiteWise. For more information, see [Ingesting data using a gateway](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse

    /**
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM to authenticate portal users and manage user permissions.
     *
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information, see [Adding or removing portal administrators](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins) in the *IoT SiteWise User Guide*.
     */
    public suspend fun createPortal(input: CreatePortalRequest): CreatePortalResponse

    /**
     * Creates a project in the specified portal.
     *
     * Make sure that the project name and description don't contain confidential information.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     */
    public suspend fun deleteAccessPolicy(input: DeleteAccessPolicyRequest): DeleteAccessPolicyResponse

    /**
     * Deletes an asset. This action can't be undone. For more information, see [Deleting assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html) in the *IoT SiteWise User Guide*.
     *
     * You can't delete an asset that's associated to another asset. For more information, see [DisassociateAssets](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html).
     */
    public suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see [Deleting assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun deleteAssetModel(input: DeleteAssetModelRequest): DeleteAssetModelResponse

    /**
     * Deletes a composite model. This action can't be undone. You must delete all assets created from a composite model before you can delete the model. Also, you can't delete a composite model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see [Deleting assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun deleteAssetModelCompositeModel(input: DeleteAssetModelCompositeModelRequest): DeleteAssetModelCompositeModelResponse

    /**
     * Deletes a computation model. This action can't be undone.
     */
    public suspend fun deleteComputationModel(input: DeleteComputationModelRequest): DeleteComputationModelResponse

    /**
     * Deletes a dashboard from IoT SiteWise Monitor.
     */
    public suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse

    /**
     * Deletes a dataset. This cannot be undone.
     */
    public suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your gateway's file system.
     */
    public suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deletes a portal from IoT SiteWise Monitor.
     */
    public suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse

    /**
     * Deletes a project from IoT SiteWise Monitor.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the asset property still exists, but the time series will no longer be associated with this asset property.
     *
     * To identify a time series, do one of the following:
     * + If the time series isn't associated with an asset property, specify the `alias` of the time series.
     * + If the time series is associated with an asset property, specify one of the following:
     *    + The `alias` of the time series.
     *    + The `assetId` and `propertyId` that identifies the asset property.
     */
    public suspend fun deleteTimeSeries(input: DeleteTimeSeriesRequest = DeleteTimeSeriesRequest { }): DeleteTimeSeriesResponse

    /**
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     */
    public suspend fun describeAccessPolicy(input: DescribeAccessPolicyRequest): DescribeAccessPolicyResponse

    /**
     * Retrieves information about an action.
     */
    public suspend fun describeAction(input: DescribeActionRequest): DescribeActionResponse

    /**
     * Retrieves information about an asset.
     */
    public suspend fun describeAsset(input: DescribeAssetRequest): DescribeAssetResponse

    /**
     * Retrieves information about an asset composite model (also known as an asset component). An `AssetCompositeModel` is an instance of an `AssetModelCompositeModel`. If you want to see information about the model this is based on, call [DescribeAssetModelCompositeModel](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html).
     */
    public suspend fun describeAssetCompositeModel(input: DescribeAssetCompositeModelRequest): DescribeAssetCompositeModelResponse

    /**
     * Retrieves information about an asset model.
     */
    public suspend fun describeAssetModel(input: DescribeAssetModelRequest): DescribeAssetModelResponse

    /**
     * Retrieves information about an asset model composite model (also known as an asset model component). For more information, see [Custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun describeAssetModelCompositeModel(input: DescribeAssetModelCompositeModelRequest): DescribeAssetModelCompositeModelResponse

    /**
     * Retrieves information about an asset property.
     *
     * When you call this operation for an attribute property, this response includes the default attribute value that you define in the asset model. If you update the default value in the model, this operation's response includes the new default value.
     *
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use [GetAssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html).
     */
    public suspend fun describeAssetProperty(input: DescribeAssetPropertyRequest): DescribeAssetPropertyResponse

    /**
     * Retrieves information about a bulk import job request. For more information, see [Describe a bulk import job (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public suspend fun describeBulkImportJob(input: DescribeBulkImportJobRequest): DescribeBulkImportJobResponse

    /**
     * Retrieves information about a computation model.
     */
    public suspend fun describeComputationModel(input: DescribeComputationModelRequest): DescribeComputationModelResponse

    /**
     * Retrieves information about the execution summary of a computation model.
     */
    public suspend fun describeComputationModelExecutionSummary(input: DescribeComputationModelExecutionSummaryRequest): DescribeComputationModelExecutionSummaryResponse

    /**
     * Retrieves information about a dashboard.
     */
    public suspend fun describeDashboard(input: DescribeDashboardRequest): DescribeDashboardResponse

    /**
     * Retrieves information about a dataset.
     */
    public suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the default or specified Region. For more information, see [Key management](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun describeDefaultEncryptionConfiguration(input: DescribeDefaultEncryptionConfigurationRequest = DescribeDefaultEncryptionConfigurationRequest { }): DescribeDefaultEncryptionConfigurationResponse

    /**
     * Retrieves information about the execution.
     */
    public suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Retrieves information about a gateway.
     */
    public suspend fun describeGateway(input: DescribeGatewayRequest): DescribeGatewayResponse

    /**
     * Each gateway capability defines data sources for a gateway. This is the namespace of the gateway capability.
     *
     * . The namespace follows the format `service:capability:version`, where:
     * + `service` - The service providing the capability, or `iotsitewise`.
     * + `capability` - The specific capability type. Options include: `opcuacollector` for the OPC UA data source collector, or `publisher` for data publisher capability.
     * + `version` - The version number of the capability. Option include `2` for Classic streams, V2 gateways, and `3` for MQTT-enabled, V3 gateways.
     *
     * After updating a capability configuration, the sync status becomes `OUT_OF_SYNC` until the gateway processes the configuration.Use `DescribeGatewayCapabilityConfiguration` to check the sync status and verify the configuration was applied.
     *
     * A gateway can have multiple capability configurations with different namespaces.
     */
    public suspend fun describeGatewayCapabilityConfiguration(input: DescribeGatewayCapabilityConfigurationRequest): DescribeGatewayCapabilityConfigurationResponse

    /**
     * Retrieves the current IoT SiteWise logging options.
     */
    public suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest = DescribeLoggingOptionsRequest { }): DescribeLoggingOptionsResponse

    /**
     * Retrieves information about a portal.
     */
    public suspend fun describePortal(input: DescribePortalRequest): DescribePortalResponse

    /**
     * Retrieves information about a project.
     */
    public suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Retrieves information about the storage configuration for IoT SiteWise.
     */
    public suspend fun describeStorageConfiguration(input: DescribeStorageConfigurationRequest = DescribeStorageConfigurationRequest { }): DescribeStorageConfigurationResponse

    /**
     * Retrieves information about a time series (data stream).
     *
     * To identify a time series, do one of the following:
     * + If the time series isn't associated with an asset property, specify the `alias` of the time series.
     * + If the time series is associated with an asset property, specify one of the following:
     *    + The `alias` of the time series.
     *    + The `assetId` and `propertyId` that identifies the asset property.
     */
    public suspend fun describeTimeSeries(input: DescribeTimeSeriesRequest = DescribeTimeSeriesRequest { }): DescribeTimeSeriesResponse

    /**
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     */
    public suspend fun disassociateAssets(input: DisassociateAssetsRequest): DisassociateAssetsResponse

    /**
     * Disassociates a time series (data stream) from an asset property.
     */
    public suspend fun disassociateTimeSeriesFromAssetProperty(input: DisassociateTimeSeriesFromAssetPropertyRequest): DisassociateTimeSeriesFromAssetPropertyResponse

    /**
     * Executes an action on a target resource.
     */
    public suspend fun executeAction(input: ExecuteActionRequest): ExecuteActionResponse

    /**
     * Run SQL queries to retrieve metadata and time-series data from asset models, assets, measurements, metrics, transforms, and aggregates.
     */
    public suspend fun executeQuery(input: ExecuteQueryRequest): ExecuteQueryResponse

    /**
     * Gets aggregated values for an asset property. For more information, see [Querying aggregates](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates) in the *IoT SiteWise User Guide*.
     *
     * To identify an asset property, you must specify one of the following:
     * + The `assetId` and `propertyId` of an asset property.
     * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
     */
    public suspend fun getAssetPropertyAggregates(input: GetAssetPropertyAggregatesRequest): GetAssetPropertyAggregatesResponse

    /**
     * Gets an asset property's current value. For more information, see [Querying current values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values) in the *IoT SiteWise User Guide*.
     *
     * To identify an asset property, you must specify one of the following:
     * + The `assetId` and `propertyId` of an asset property.
     * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
     */
    public suspend fun getAssetPropertyValue(input: GetAssetPropertyValueRequest = GetAssetPropertyValueRequest { }): GetAssetPropertyValueResponse

    /**
     * Gets the history of an asset property's values. For more information, see [Querying historical values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values) in the *IoT SiteWise User Guide*.
     *
     * To identify an asset property, you must specify one of the following:
     * + The `assetId` and `propertyId` of an asset property.
     * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
     */
    public suspend fun getAssetPropertyValueHistory(input: GetAssetPropertyValueHistoryRequest = GetAssetPropertyValueHistoryRequest { }): GetAssetPropertyValueHistoryResponse

    /**
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your time series is missing data points during the specified time interval, you can use interpolation to estimate the missing data.
     *
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
     *
     * To identify an asset property, you must specify one of the following:
     * + The `assetId` and `propertyId` of an asset property.
     * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
     */
    public suspend fun getInterpolatedAssetPropertyValues(input: GetInterpolatedAssetPropertyValuesRequest): GetInterpolatedAssetPropertyValuesResponse

    /**
     * Invokes SiteWise Assistant to start or continue a conversation.
     */
    public suspend fun <T> invokeAssistant(input: InvokeAssistantRequest, block: suspend (InvokeAssistantResponse) -> T): T

    /**
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     */
    public suspend fun listAccessPolicies(input: ListAccessPoliciesRequest = ListAccessPoliciesRequest { }): ListAccessPoliciesResponse

    /**
     * Retrieves a paginated list of actions for a specific target resource.
     */
    public suspend fun listActions(input: ListActionsRequest): ListActionsResponse

    /**
     * Retrieves a paginated list of composite models associated with the asset model
     */
    public suspend fun listAssetModelCompositeModels(input: ListAssetModelCompositeModelsRequest): ListAssetModelCompositeModelsResponse

    /**
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with the model before you finish listing all the properties, you need to start all over again.
     */
    public suspend fun listAssetModelProperties(input: ListAssetModelPropertiesRequest): ListAssetModelPropertiesResponse

    /**
     * Retrieves a paginated list of summaries of all asset models.
     */
    public suspend fun listAssetModels(input: ListAssetModelsRequest = ListAssetModelsRequest { }): ListAssetModelsResponse

    /**
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the model before you finish listing all the properties, you need to start all over again.
     */
    public suspend fun listAssetProperties(input: ListAssetPropertiesRequest): ListAssetPropertiesResponse

    /**
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's root asset and all associated assets between that asset and its root.
     */
    public suspend fun listAssetRelationships(input: ListAssetRelationshipsRequest): ListAssetRelationshipsResponse

    /**
     * Retrieves a paginated list of asset summaries.
     *
     * You can use this operation to do the following:
     * + List assets based on a specific asset model.
     * + List top-level assets.
     *
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use [ListAssetModels](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html) to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     */
    public suspend fun listAssets(input: ListAssetsRequest = ListAssetsRequest { }): ListAssetsResponse

    /**
     * Retrieves a paginated list of associated assets.
     *
     * You can use this operation to do the following:
     * + `CHILD` - List all child assets associated to the asset.
     * + `PARENT` - List the asset's parent asset.
     */
    public suspend fun listAssociatedAssets(input: ListAssociatedAssetsRequest): ListAssociatedAssetsResponse

    /**
     * Retrieves a paginated list of bulk import job requests. For more information, see [List bulk import jobs (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun listBulkImportJobs(input: ListBulkImportJobsRequest = ListBulkImportJobsRequest { }): ListBulkImportJobsResponse

    /**
     * Retrieves a paginated list of composition relationships for an asset model of type `COMPONENT_MODEL`.
     */
    public suspend fun listCompositionRelationships(input: ListCompositionRelationshipsRequest): ListCompositionRelationshipsResponse

    /**
     * Lists all data binding usages for computation models. This allows to identify where specific data bindings are being utilized across the computation models. This track dependencies between data sources and computation models.
     */
    public suspend fun listComputationModelDataBindingUsages(input: ListComputationModelDataBindingUsagesRequest): ListComputationModelDataBindingUsagesResponse

    /**
     * Lists all distinct resources that are resolved from the executed actions of the computation model.
     */
    public suspend fun listComputationModelResolveToResources(input: ListComputationModelResolveToResourcesRequest): ListComputationModelResolveToResourcesResponse

    /**
     * Retrieves a paginated list of summaries of all computation models.
     */
    public suspend fun listComputationModels(input: ListComputationModelsRequest = ListComputationModelsRequest { }): ListComputationModelsResponse

    /**
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     */
    public suspend fun listDashboards(input: ListDashboardsRequest): ListDashboardsResponse

    /**
     * Retrieves a paginated list of datasets for a specific target resource.
     */
    public suspend fun listDatasets(input: ListDatasetsRequest): ListDatasetsResponse

    /**
     * Retrieves a paginated list of summaries of all executions.
     */
    public suspend fun listExecutions(input: ListExecutionsRequest): ListExecutionsResponse

    /**
     * Retrieves a paginated list of gateways.
     */
    public suspend fun listGateways(input: ListGatewaysRequest = ListGatewaysRequest { }): ListGatewaysResponse

    /**
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     */
    public suspend fun listPortals(input: ListPortalsRequest = ListPortalsRequest { }): ListPortalsResponse

    /**
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     */
    public suspend fun listProjectAssets(input: ListProjectAssetsRequest): ListProjectAssetsResponse

    /**
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     */
    public suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Retrieves the list of tags for an IoT SiteWise resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a paginated list of time series (data streams).
     */
    public suspend fun listTimeSeries(input: ListTimeSeriesRequest = ListTimeSeriesRequest { }): ListTimeSeriesResponse

    /**
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see [Key management](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun putDefaultEncryptionConfiguration(input: PutDefaultEncryptionConfigurationRequest): PutDefaultEncryptionConfigurationResponse

    /**
     * Sets logging options for IoT SiteWise.
     */
    public suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Configures storage settings for IoT SiteWise.
     */
    public suspend fun putStorageConfiguration(input: PutStorageConfigurationRequest): PutStorageConfigurationResponse

    /**
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from an IoT SiteWise resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or project resource.
     */
    public suspend fun updateAccessPolicy(input: UpdateAccessPolicyRequest): UpdateAccessPolicyResponse

    /**
     * Updates an asset's name. For more information, see [Updating assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html) in the *IoT SiteWise User Guide*.
     */
    public suspend fun updateAsset(input: UpdateAssetRequest): UpdateAssetResponse

    /**
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model's property and hierarchy definitions. For more information, see [Updating assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html) in the *IoT SiteWise User Guide*.
     *
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. You can’t change the type or data type of an existing property.
     *
     * To replace an existing asset model property with a new one with the same `name`, do the following:
     * + Submit an `UpdateAssetModel` request with the entire existing property removed.
     * + Submit a second `UpdateAssetModel` request that includes the new property. The new asset property will have the same `name` as the previous one and IoT SiteWise will generate a new unique `id`.
     */
    public suspend fun updateAssetModel(input: UpdateAssetModelRequest): UpdateAssetModelResponse

    /**
     * Updates a composite model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model's property and hierarchy definitions. For more information, see [Updating assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html) in the *IoT SiteWise User Guide*.
     *
     * If you remove a property from a composite asset model, IoT SiteWise deletes all previous data for that property. You can’t change the type or data type of an existing property.
     *
     * To replace an existing composite asset model property with a new one with the same `name`, do the following:
     * + Submit an `UpdateAssetModelCompositeModel` request with the entire existing property removed.
     * + Submit a second `UpdateAssetModelCompositeModel` request that includes the new property. The new asset property will have the same `name` as the previous one and IoT SiteWise will generate a new unique `id`.
     */
    public suspend fun updateAssetModelCompositeModel(input: UpdateAssetModelCompositeModelRequest): UpdateAssetModelCompositeModelResponse

    /**
     * Updates an asset property's alias and notification state.
     *
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more information, see [DescribeAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html).
     */
    public suspend fun updateAssetProperty(input: UpdateAssetPropertyRequest): UpdateAssetPropertyResponse

    /**
     * Updates the computation model.
     */
    public suspend fun updateComputationModel(input: UpdateComputationModelRequest): UpdateComputationModelResponse

    /**
     * Updates an IoT SiteWise Monitor dashboard.
     */
    public suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse

    /**
     * Updates a dataset.
     */
    public suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse

    /**
     * Updates a gateway's name.
     */
    public suspend fun updateGateway(input: UpdateGatewayRequest): UpdateGatewayResponse

    /**
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability defines data sources for a gateway.
     *
     * Important workflow notes:
     *
     * Each gateway capability defines data sources for a gateway. This is the namespace of the gateway capability.
     *
     * . The namespace follows the format `service:capability:version`, where:
     * + `service` - The service providing the capability, or `iotsitewise`.
     * + `capability` - The specific capability type. Options include: `opcuacollector` for the OPC UA data source collector, or `publisher` for data publisher capability.
     * + `version` - The version number of the capability. Option include `2` for Classic streams, V2 gateways, and `3` for MQTT-enabled, V3 gateways.
     *
     * After updating a capability configuration, the sync status becomes `OUT_OF_SYNC` until the gateway processes the configuration.Use `DescribeGatewayCapabilityConfiguration` to check the sync status and verify the configuration was applied.
     *
     * A gateway can have multiple capability configurations with different namespaces.
     */
    public suspend fun updateGatewayCapabilityConfiguration(input: UpdateGatewayCapabilityConfigurationRequest): UpdateGatewayCapabilityConfigurationResponse

    /**
     * Updates an IoT SiteWise Monitor portal.
     */
    public suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse

    /**
     * Updates an IoT SiteWise Monitor project.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotSiteWiseClient.withConfig(block: IotSiteWiseClient.Config.Builder.() -> Unit): IotSiteWiseClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotSiteWiseClient(newConfig)
}

/**
 * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For more information, see [Associating assets](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.associateAssets(crossinline block: AssociateAssetsRequest.Builder.() -> Unit): AssociateAssetsResponse = associateAssets(AssociateAssetsRequest.Builder().apply(block).build())

/**
 * Associates a time series (data stream) with an asset property.
 */
public suspend inline fun IotSiteWiseClient.associateTimeSeriesToAssetProperty(crossinline block: AssociateTimeSeriesToAssetPropertyRequest.Builder.() -> Unit): AssociateTimeSeriesToAssetPropertyResponse = associateTimeSeriesToAssetProperty(AssociateTimeSeriesToAssetPropertyRequest.Builder().apply(block).build())

/**
 * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
 */
public suspend inline fun IotSiteWiseClient.batchAssociateProjectAssets(crossinline block: BatchAssociateProjectAssetsRequest.Builder.() -> Unit): BatchAssociateProjectAssetsResponse = batchAssociateProjectAssets(BatchAssociateProjectAssetsRequest.Builder().apply(block).build())

/**
 * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
 */
public suspend inline fun IotSiteWiseClient.batchDisassociateProjectAssets(crossinline block: BatchDisassociateProjectAssetsRequest.Builder.() -> Unit): BatchDisassociateProjectAssetsResponse = batchDisassociateProjectAssets(BatchDisassociateProjectAssetsRequest.Builder().apply(block).build())

/**
 * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more information, see [Querying aggregates](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.batchGetAssetPropertyAggregates(crossinline block: BatchGetAssetPropertyAggregatesRequest.Builder.() -> Unit): BatchGetAssetPropertyAggregatesResponse = batchGetAssetPropertyAggregates(BatchGetAssetPropertyAggregatesRequest.Builder().apply(block).build())

/**
 * Gets the current value for one or more asset properties. For more information, see [Querying current values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.batchGetAssetPropertyValue(crossinline block: BatchGetAssetPropertyValueRequest.Builder.() -> Unit): BatchGetAssetPropertyValueResponse = batchGetAssetPropertyValue(BatchGetAssetPropertyValueRequest.Builder().apply(block).build())

/**
 * Gets the historical values for one or more asset properties. For more information, see [Querying historical values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.batchGetAssetPropertyValueHistory(crossinline block: BatchGetAssetPropertyValueHistoryRequest.Builder.() -> Unit): BatchGetAssetPropertyValueHistoryResponse = batchGetAssetPropertyValueHistory(BatchGetAssetPropertyValueHistoryRequest.Builder().apply(block).build())

/**
 * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point. For more information, see [Ingesting data using the API](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html) in the *IoT SiteWise User Guide*.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 *
 * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive range of &#91;-7 days, +10 minutes&#93; and returns a `TimestampOutOfRangeException` error.
 *
 * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a different quality. For example, if you store a TQV `{T1, GOOD, V1}`, then storing `{T1, GOOD, V2}` replaces the existing TQV.
 *
 * IoT SiteWise authorizes access to each `BatchPutAssetPropertyValue` entry individually. For more information, see [BatchPutAssetPropertyValue authorization](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.batchPutAssetPropertyValue(crossinline block: BatchPutAssetPropertyValueRequest.Builder.() -> Unit): BatchPutAssetPropertyValueResponse = batchPutAssetPropertyValue(BatchPutAssetPropertyValueRequest.Builder().apply(block).build())

/**
 * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group, or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
 */
public suspend inline fun IotSiteWiseClient.createAccessPolicy(crossinline block: CreateAccessPolicyRequest.Builder.() -> Unit): CreateAccessPolicyResponse = createAccessPolicy(CreateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Creates an asset from an existing asset model. For more information, see [Creating assets](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.createAsset(crossinline block: CreateAssetRequest.Builder.() -> Unit): CreateAssetResponse = createAsset(CreateAssetRequest.Builder().apply(block).build())

/**
 * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models. With asset models, you can easily create assets of the same type that have standardized definitions. Each asset created from a model inherits the asset model's property and hierarchy definitions. For more information, see [Defining asset models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html) in the *IoT SiteWise User Guide*.
 *
 * You can create two types of asset models, `ASSET_MODEL` or `COMPONENT_MODEL`.
 * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
 * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
 */
public suspend inline fun IotSiteWiseClient.createAssetModel(crossinline block: CreateAssetModelRequest.Builder.() -> Unit): CreateAssetModelResponse = createAssetModel(CreateAssetModelRequest.Builder().apply(block).build())

/**
 * Creates a custom composite model from specified property and hierarchy definitions. There are two types of custom composite models, `inline` and `component-model-based`.
 *
 * Use component-model-based custom composite models to define standard, reusable components. A component-model-based custom composite model consists of a name, a description, and the ID of the component model it references. A component-model-based custom composite model has no properties of its own; its referenced component model provides its associated properties to any created assets. For more information, see [Custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html) in the *IoT SiteWise User Guide*.
 *
 * Use inline custom composite models to organize the properties of an asset model. The properties of inline custom composite models are local to the asset model where they are included and can't be used to create multiple assets.
 *
 * To create a component-model-based model, specify the `composedAssetModelId` of an existing asset model with `assetModelType` of `COMPONENT_MODEL`.
 *
 * To create an inline model, specify the `assetModelCompositeModelProperties` and don't include an `composedAssetModelId`.
 */
public suspend inline fun IotSiteWiseClient.createAssetModelCompositeModel(crossinline block: CreateAssetModelCompositeModelRequest.Builder.() -> Unit): CreateAssetModelCompositeModelResponse = createAssetModelCompositeModel(CreateAssetModelCompositeModelRequest.Builder().apply(block).build())

/**
 * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see [Create a bulk import job (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html) in the *Amazon Simple Storage Service User Guide*.
 *
 * Before you create a bulk import job, you must enable IoT SiteWise warm tier or IoT SiteWise cold tier. For more information about how to configure storage settings, see [PutStorageConfiguration](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html).
 *
 * Bulk import is designed to store historical data to IoT SiteWise.
 * + Newly ingested data in the hot tier triggers notifications and computations.
 * + After data moves from the hot tier to the warm or cold tier based on retention settings, it does not trigger computations or notifications.
 * + Data older than 7 days does not trigger computations or notifications.
 */
public suspend inline fun IotSiteWiseClient.createBulkImportJob(crossinline block: CreateBulkImportJobRequest.Builder.() -> Unit): CreateBulkImportJobResponse = createBulkImportJob(CreateBulkImportJobRequest.Builder().apply(block).build())

/**
 * Create a computation model with a configuration and data binding.
 */
public suspend inline fun IotSiteWiseClient.createComputationModel(crossinline block: CreateComputationModelRequest.Builder.() -> Unit): CreateComputationModelResponse = createComputationModel(CreateComputationModelRequest.Builder().apply(block).build())

/**
 * Creates a dashboard in an IoT SiteWise Monitor project.
 */
public suspend inline fun IotSiteWiseClient.createDashboard(crossinline block: CreateDashboardRequest.Builder.() -> Unit): CreateDashboardResponse = createDashboard(CreateDashboardRequest.Builder().apply(block).build())

/**
 * Creates a dataset to connect an external datasource.
 */
public suspend inline fun IotSiteWiseClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit): CreateDatasetResponse = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to IoT SiteWise. For more information, see [Ingesting data using a gateway](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.createGateway(crossinline block: CreateGatewayRequest.Builder.() -> Unit): CreateGatewayResponse = createGateway(CreateGatewayRequest.Builder().apply(block).build())

/**
 * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM to authenticate portal users and manage user permissions.
 *
 * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information, see [Adding or removing portal administrators](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.createPortal(crossinline block: CreatePortalRequest.Builder.() -> Unit): CreatePortalResponse = createPortal(CreatePortalRequest.Builder().apply(block).build())

/**
 * Creates a project in the specified portal.
 *
 * Make sure that the project name and description don't contain confidential information.
 */
public suspend inline fun IotSiteWiseClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
 */
public suspend inline fun IotSiteWiseClient.deleteAccessPolicy(crossinline block: DeleteAccessPolicyRequest.Builder.() -> Unit): DeleteAccessPolicyResponse = deleteAccessPolicy(DeleteAccessPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an asset. This action can't be undone. For more information, see [Deleting assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html) in the *IoT SiteWise User Guide*.
 *
 * You can't delete an asset that's associated to another asset. For more information, see [DisassociateAssets](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html).
 */
public suspend inline fun IotSiteWiseClient.deleteAsset(crossinline block: DeleteAssetRequest.Builder.() -> Unit): DeleteAssetResponse = deleteAsset(DeleteAssetRequest.Builder().apply(block).build())

/**
 * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see [Deleting assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.deleteAssetModel(crossinline block: DeleteAssetModelRequest.Builder.() -> Unit): DeleteAssetModelResponse = deleteAssetModel(DeleteAssetModelRequest.Builder().apply(block).build())

/**
 * Deletes a composite model. This action can't be undone. You must delete all assets created from a composite model before you can delete the model. Also, you can't delete a composite model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see [Deleting assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.deleteAssetModelCompositeModel(crossinline block: DeleteAssetModelCompositeModelRequest.Builder.() -> Unit): DeleteAssetModelCompositeModelResponse = deleteAssetModelCompositeModel(DeleteAssetModelCompositeModelRequest.Builder().apply(block).build())

/**
 * Deletes a computation model. This action can't be undone.
 */
public suspend inline fun IotSiteWiseClient.deleteComputationModel(crossinline block: DeleteComputationModelRequest.Builder.() -> Unit): DeleteComputationModelResponse = deleteComputationModel(DeleteComputationModelRequest.Builder().apply(block).build())

/**
 * Deletes a dashboard from IoT SiteWise Monitor.
 */
public suspend inline fun IotSiteWiseClient.deleteDashboard(crossinline block: DeleteDashboardRequest.Builder.() -> Unit): DeleteDashboardResponse = deleteDashboard(DeleteDashboardRequest.Builder().apply(block).build())

/**
 * Deletes a dataset. This cannot be undone.
 */
public suspend inline fun IotSiteWiseClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit): DeleteDatasetResponse = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your gateway's file system.
 */
public suspend inline fun IotSiteWiseClient.deleteGateway(crossinline block: DeleteGatewayRequest.Builder.() -> Unit): DeleteGatewayResponse = deleteGateway(DeleteGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a portal from IoT SiteWise Monitor.
 */
public suspend inline fun IotSiteWiseClient.deletePortal(crossinline block: DeletePortalRequest.Builder.() -> Unit): DeletePortalResponse = deletePortal(DeletePortalRequest.Builder().apply(block).build())

/**
 * Deletes a project from IoT SiteWise Monitor.
 */
public suspend inline fun IotSiteWiseClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the asset property still exists, but the time series will no longer be associated with this asset property.
 *
 * To identify a time series, do one of the following:
 * + If the time series isn't associated with an asset property, specify the `alias` of the time series.
 * + If the time series is associated with an asset property, specify one of the following:
 *    + The `alias` of the time series.
 *    + The `assetId` and `propertyId` that identifies the asset property.
 */
public suspend inline fun IotSiteWiseClient.deleteTimeSeries(crossinline block: DeleteTimeSeriesRequest.Builder.() -> Unit): DeleteTimeSeriesResponse = deleteTimeSeries(DeleteTimeSeriesRequest.Builder().apply(block).build())

/**
 * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
 */
public suspend inline fun IotSiteWiseClient.describeAccessPolicy(crossinline block: DescribeAccessPolicyRequest.Builder.() -> Unit): DescribeAccessPolicyResponse = describeAccessPolicy(DescribeAccessPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about an action.
 */
public suspend inline fun IotSiteWiseClient.describeAction(crossinline block: DescribeActionRequest.Builder.() -> Unit): DescribeActionResponse = describeAction(DescribeActionRequest.Builder().apply(block).build())

/**
 * Retrieves information about an asset.
 */
public suspend inline fun IotSiteWiseClient.describeAsset(crossinline block: DescribeAssetRequest.Builder.() -> Unit): DescribeAssetResponse = describeAsset(DescribeAssetRequest.Builder().apply(block).build())

/**
 * Retrieves information about an asset composite model (also known as an asset component). An `AssetCompositeModel` is an instance of an `AssetModelCompositeModel`. If you want to see information about the model this is based on, call [DescribeAssetModelCompositeModel](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html).
 */
public suspend inline fun IotSiteWiseClient.describeAssetCompositeModel(crossinline block: DescribeAssetCompositeModelRequest.Builder.() -> Unit): DescribeAssetCompositeModelResponse = describeAssetCompositeModel(DescribeAssetCompositeModelRequest.Builder().apply(block).build())

/**
 * Retrieves information about an asset model.
 */
public suspend inline fun IotSiteWiseClient.describeAssetModel(crossinline block: DescribeAssetModelRequest.Builder.() -> Unit): DescribeAssetModelResponse = describeAssetModel(DescribeAssetModelRequest.Builder().apply(block).build())

/**
 * Retrieves information about an asset model composite model (also known as an asset model component). For more information, see [Custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.describeAssetModelCompositeModel(crossinline block: DescribeAssetModelCompositeModelRequest.Builder.() -> Unit): DescribeAssetModelCompositeModelResponse = describeAssetModelCompositeModel(DescribeAssetModelCompositeModelRequest.Builder().apply(block).build())

/**
 * Retrieves information about an asset property.
 *
 * When you call this operation for an attribute property, this response includes the default attribute value that you define in the asset model. If you update the default value in the model, this operation's response includes the new default value.
 *
 * This operation doesn't return the value of the asset property. To get the value of an asset property, use [GetAssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html).
 */
public suspend inline fun IotSiteWiseClient.describeAssetProperty(crossinline block: DescribeAssetPropertyRequest.Builder.() -> Unit): DescribeAssetPropertyResponse = describeAssetProperty(DescribeAssetPropertyRequest.Builder().apply(block).build())

/**
 * Retrieves information about a bulk import job request. For more information, see [Describe a bulk import job (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html) in the *Amazon Simple Storage Service User Guide*.
 */
public suspend inline fun IotSiteWiseClient.describeBulkImportJob(crossinline block: DescribeBulkImportJobRequest.Builder.() -> Unit): DescribeBulkImportJobResponse = describeBulkImportJob(DescribeBulkImportJobRequest.Builder().apply(block).build())

/**
 * Retrieves information about a computation model.
 */
public suspend inline fun IotSiteWiseClient.describeComputationModel(crossinline block: DescribeComputationModelRequest.Builder.() -> Unit): DescribeComputationModelResponse = describeComputationModel(DescribeComputationModelRequest.Builder().apply(block).build())

/**
 * Retrieves information about the execution summary of a computation model.
 */
public suspend inline fun IotSiteWiseClient.describeComputationModelExecutionSummary(crossinline block: DescribeComputationModelExecutionSummaryRequest.Builder.() -> Unit): DescribeComputationModelExecutionSummaryResponse = describeComputationModelExecutionSummary(DescribeComputationModelExecutionSummaryRequest.Builder().apply(block).build())

/**
 * Retrieves information about a dashboard.
 */
public suspend inline fun IotSiteWiseClient.describeDashboard(crossinline block: DescribeDashboardRequest.Builder.() -> Unit): DescribeDashboardResponse = describeDashboard(DescribeDashboardRequest.Builder().apply(block).build())

/**
 * Retrieves information about a dataset.
 */
public suspend inline fun IotSiteWiseClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit): DescribeDatasetResponse = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Retrieves information about the default encryption configuration for the Amazon Web Services account in the default or specified Region. For more information, see [Key management](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.describeDefaultEncryptionConfiguration(crossinline block: DescribeDefaultEncryptionConfigurationRequest.Builder.() -> Unit): DescribeDefaultEncryptionConfigurationResponse = describeDefaultEncryptionConfiguration(DescribeDefaultEncryptionConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about the execution.
 */
public suspend inline fun IotSiteWiseClient.describeExecution(crossinline block: DescribeExecutionRequest.Builder.() -> Unit): DescribeExecutionResponse = describeExecution(DescribeExecutionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a gateway.
 */
public suspend inline fun IotSiteWiseClient.describeGateway(crossinline block: DescribeGatewayRequest.Builder.() -> Unit): DescribeGatewayResponse = describeGateway(DescribeGatewayRequest.Builder().apply(block).build())

/**
 * Each gateway capability defines data sources for a gateway. This is the namespace of the gateway capability.
 *
 * . The namespace follows the format `service:capability:version`, where:
 * + `service` - The service providing the capability, or `iotsitewise`.
 * + `capability` - The specific capability type. Options include: `opcuacollector` for the OPC UA data source collector, or `publisher` for data publisher capability.
 * + `version` - The version number of the capability. Option include `2` for Classic streams, V2 gateways, and `3` for MQTT-enabled, V3 gateways.
 *
 * After updating a capability configuration, the sync status becomes `OUT_OF_SYNC` until the gateway processes the configuration.Use `DescribeGatewayCapabilityConfiguration` to check the sync status and verify the configuration was applied.
 *
 * A gateway can have multiple capability configurations with different namespaces.
 */
public suspend inline fun IotSiteWiseClient.describeGatewayCapabilityConfiguration(crossinline block: DescribeGatewayCapabilityConfigurationRequest.Builder.() -> Unit): DescribeGatewayCapabilityConfigurationResponse = describeGatewayCapabilityConfiguration(DescribeGatewayCapabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the current IoT SiteWise logging options.
 */
public suspend inline fun IotSiteWiseClient.describeLoggingOptions(crossinline block: DescribeLoggingOptionsRequest.Builder.() -> Unit): DescribeLoggingOptionsResponse = describeLoggingOptions(DescribeLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about a portal.
 */
public suspend inline fun IotSiteWiseClient.describePortal(crossinline block: DescribePortalRequest.Builder.() -> Unit): DescribePortalResponse = describePortal(DescribePortalRequest.Builder().apply(block).build())

/**
 * Retrieves information about a project.
 */
public suspend inline fun IotSiteWiseClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit): DescribeProjectResponse = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Retrieves information about the storage configuration for IoT SiteWise.
 */
public suspend inline fun IotSiteWiseClient.describeStorageConfiguration(crossinline block: DescribeStorageConfigurationRequest.Builder.() -> Unit): DescribeStorageConfigurationResponse = describeStorageConfiguration(DescribeStorageConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about a time series (data stream).
 *
 * To identify a time series, do one of the following:
 * + If the time series isn't associated with an asset property, specify the `alias` of the time series.
 * + If the time series is associated with an asset property, specify one of the following:
 *    + The `alias` of the time series.
 *    + The `assetId` and `propertyId` that identifies the asset property.
 */
public suspend inline fun IotSiteWiseClient.describeTimeSeries(crossinline block: DescribeTimeSeriesRequest.Builder.() -> Unit): DescribeTimeSeriesResponse = describeTimeSeries(DescribeTimeSeriesRequest.Builder().apply(block).build())

/**
 * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
 */
public suspend inline fun IotSiteWiseClient.disassociateAssets(crossinline block: DisassociateAssetsRequest.Builder.() -> Unit): DisassociateAssetsResponse = disassociateAssets(DisassociateAssetsRequest.Builder().apply(block).build())

/**
 * Disassociates a time series (data stream) from an asset property.
 */
public suspend inline fun IotSiteWiseClient.disassociateTimeSeriesFromAssetProperty(crossinline block: DisassociateTimeSeriesFromAssetPropertyRequest.Builder.() -> Unit): DisassociateTimeSeriesFromAssetPropertyResponse = disassociateTimeSeriesFromAssetProperty(DisassociateTimeSeriesFromAssetPropertyRequest.Builder().apply(block).build())

/**
 * Executes an action on a target resource.
 */
public suspend inline fun IotSiteWiseClient.executeAction(crossinline block: ExecuteActionRequest.Builder.() -> Unit): ExecuteActionResponse = executeAction(ExecuteActionRequest.Builder().apply(block).build())

/**
 * Run SQL queries to retrieve metadata and time-series data from asset models, assets, measurements, metrics, transforms, and aggregates.
 */
public suspend inline fun IotSiteWiseClient.executeQuery(crossinline block: ExecuteQueryRequest.Builder.() -> Unit): ExecuteQueryResponse = executeQuery(ExecuteQueryRequest.Builder().apply(block).build())

/**
 * Gets aggregated values for an asset property. For more information, see [Querying aggregates](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates) in the *IoT SiteWise User Guide*.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 */
public suspend inline fun IotSiteWiseClient.getAssetPropertyAggregates(crossinline block: GetAssetPropertyAggregatesRequest.Builder.() -> Unit): GetAssetPropertyAggregatesResponse = getAssetPropertyAggregates(GetAssetPropertyAggregatesRequest.Builder().apply(block).build())

/**
 * Gets an asset property's current value. For more information, see [Querying current values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values) in the *IoT SiteWise User Guide*.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 */
public suspend inline fun IotSiteWiseClient.getAssetPropertyValue(crossinline block: GetAssetPropertyValueRequest.Builder.() -> Unit): GetAssetPropertyValueResponse = getAssetPropertyValue(GetAssetPropertyValueRequest.Builder().apply(block).build())

/**
 * Gets the history of an asset property's values. For more information, see [Querying historical values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values) in the *IoT SiteWise User Guide*.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 */
public suspend inline fun IotSiteWiseClient.getAssetPropertyValueHistory(crossinline block: GetAssetPropertyValueHistoryRequest.Builder.() -> Unit): GetAssetPropertyValueHistoryResponse = getAssetPropertyValueHistory(GetAssetPropertyValueHistoryRequest.Builder().apply(block).build())

/**
 * Get interpolated values for an asset property for a specified time interval, during a period of time. If your time series is missing data points during the specified time interval, you can use interpolation to estimate the missing data.
 *
 * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 */
public suspend inline fun IotSiteWiseClient.getInterpolatedAssetPropertyValues(crossinline block: GetInterpolatedAssetPropertyValuesRequest.Builder.() -> Unit): GetInterpolatedAssetPropertyValuesResponse = getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
 */
public suspend inline fun IotSiteWiseClient.listAccessPolicies(crossinline block: ListAccessPoliciesRequest.Builder.() -> Unit): ListAccessPoliciesResponse = listAccessPolicies(ListAccessPoliciesRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of actions for a specific target resource.
 */
public suspend inline fun IotSiteWiseClient.listActions(crossinline block: ListActionsRequest.Builder.() -> Unit): ListActionsResponse = listActions(ListActionsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of composite models associated with the asset model
 */
public suspend inline fun IotSiteWiseClient.listAssetModelCompositeModels(crossinline block: ListAssetModelCompositeModelsRequest.Builder.() -> Unit): ListAssetModelCompositeModelsResponse = listAssetModelCompositeModels(ListAssetModelCompositeModelsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with the model before you finish listing all the properties, you need to start all over again.
 */
public suspend inline fun IotSiteWiseClient.listAssetModelProperties(crossinline block: ListAssetModelPropertiesRequest.Builder.() -> Unit): ListAssetModelPropertiesResponse = listAssetModelProperties(ListAssetModelPropertiesRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of summaries of all asset models.
 */
public suspend inline fun IotSiteWiseClient.listAssetModels(crossinline block: ListAssetModelsRequest.Builder.() -> Unit): ListAssetModelsResponse = listAssetModels(ListAssetModelsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the model before you finish listing all the properties, you need to start all over again.
 */
public suspend inline fun IotSiteWiseClient.listAssetProperties(crossinline block: ListAssetPropertiesRequest.Builder.() -> Unit): ListAssetPropertiesResponse = listAssetProperties(ListAssetPropertiesRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's root asset and all associated assets between that asset and its root.
 */
public suspend inline fun IotSiteWiseClient.listAssetRelationships(crossinline block: ListAssetRelationshipsRequest.Builder.() -> Unit): ListAssetRelationshipsResponse = listAssetRelationships(ListAssetRelationshipsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of asset summaries.
 *
 * You can use this operation to do the following:
 * + List assets based on a specific asset model.
 * + List top-level assets.
 *
 * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use [ListAssetModels](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html) to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
 */
public suspend inline fun IotSiteWiseClient.listAssets(crossinline block: ListAssetsRequest.Builder.() -> Unit): ListAssetsResponse = listAssets(ListAssetsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of associated assets.
 *
 * You can use this operation to do the following:
 * + `CHILD` - List all child assets associated to the asset.
 * + `PARENT` - List the asset's parent asset.
 */
public suspend inline fun IotSiteWiseClient.listAssociatedAssets(crossinline block: ListAssociatedAssetsRequest.Builder.() -> Unit): ListAssociatedAssetsResponse = listAssociatedAssets(ListAssociatedAssetsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of bulk import job requests. For more information, see [List bulk import jobs (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.listBulkImportJobs(crossinline block: ListBulkImportJobsRequest.Builder.() -> Unit): ListBulkImportJobsResponse = listBulkImportJobs(ListBulkImportJobsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of composition relationships for an asset model of type `COMPONENT_MODEL`.
 */
public suspend inline fun IotSiteWiseClient.listCompositionRelationships(crossinline block: ListCompositionRelationshipsRequest.Builder.() -> Unit): ListCompositionRelationshipsResponse = listCompositionRelationships(ListCompositionRelationshipsRequest.Builder().apply(block).build())

/**
 * Lists all data binding usages for computation models. This allows to identify where specific data bindings are being utilized across the computation models. This track dependencies between data sources and computation models.
 */
public suspend inline fun IotSiteWiseClient.listComputationModelDataBindingUsages(crossinline block: ListComputationModelDataBindingUsagesRequest.Builder.() -> Unit): ListComputationModelDataBindingUsagesResponse = listComputationModelDataBindingUsages(ListComputationModelDataBindingUsagesRequest.Builder().apply(block).build())

/**
 * Lists all distinct resources that are resolved from the executed actions of the computation model.
 */
public suspend inline fun IotSiteWiseClient.listComputationModelResolveToResources(crossinline block: ListComputationModelResolveToResourcesRequest.Builder.() -> Unit): ListComputationModelResolveToResourcesResponse = listComputationModelResolveToResources(ListComputationModelResolveToResourcesRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of summaries of all computation models.
 */
public suspend inline fun IotSiteWiseClient.listComputationModels(crossinline block: ListComputationModelsRequest.Builder.() -> Unit): ListComputationModelsResponse = listComputationModels(ListComputationModelsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
 */
public suspend inline fun IotSiteWiseClient.listDashboards(crossinline block: ListDashboardsRequest.Builder.() -> Unit): ListDashboardsResponse = listDashboards(ListDashboardsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of datasets for a specific target resource.
 */
public suspend inline fun IotSiteWiseClient.listDatasets(crossinline block: ListDatasetsRequest.Builder.() -> Unit): ListDatasetsResponse = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of summaries of all executions.
 */
public suspend inline fun IotSiteWiseClient.listExecutions(crossinline block: ListExecutionsRequest.Builder.() -> Unit): ListExecutionsResponse = listExecutions(ListExecutionsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of gateways.
 */
public suspend inline fun IotSiteWiseClient.listGateways(crossinline block: ListGatewaysRequest.Builder.() -> Unit): ListGatewaysResponse = listGateways(ListGatewaysRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of IoT SiteWise Monitor portals.
 */
public suspend inline fun IotSiteWiseClient.listPortals(crossinline block: ListPortalsRequest.Builder.() -> Unit): ListPortalsResponse = listPortals(ListPortalsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
 */
public suspend inline fun IotSiteWiseClient.listProjectAssets(crossinline block: ListProjectAssetsRequest.Builder.() -> Unit): ListProjectAssetsResponse = listProjectAssets(ListProjectAssetsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
 */
public suspend inline fun IotSiteWiseClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of tags for an IoT SiteWise resource.
 */
public suspend inline fun IotSiteWiseClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of time series (data streams).
 */
public suspend inline fun IotSiteWiseClient.listTimeSeries(crossinline block: ListTimeSeriesRequest.Builder.() -> Unit): ListTimeSeriesResponse = listTimeSeries(ListTimeSeriesRequest.Builder().apply(block).build())

/**
 * Sets the default encryption configuration for the Amazon Web Services account. For more information, see [Key management](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.putDefaultEncryptionConfiguration(crossinline block: PutDefaultEncryptionConfigurationRequest.Builder.() -> Unit): PutDefaultEncryptionConfigurationResponse = putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest.Builder().apply(block).build())

/**
 * Sets logging options for IoT SiteWise.
 */
public suspend inline fun IotSiteWiseClient.putLoggingOptions(crossinline block: PutLoggingOptionsRequest.Builder.() -> Unit): PutLoggingOptionsResponse = putLoggingOptions(PutLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Configures storage settings for IoT SiteWise.
 */
public suspend inline fun IotSiteWiseClient.putStorageConfiguration(crossinline block: PutStorageConfigurationRequest.Builder.() -> Unit): PutStorageConfigurationResponse = putStorageConfiguration(PutStorageConfigurationRequest.Builder().apply(block).build())

/**
 * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's value.
 */
public suspend inline fun IotSiteWiseClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from an IoT SiteWise resource.
 */
public suspend inline fun IotSiteWiseClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or project resource.
 */
public suspend inline fun IotSiteWiseClient.updateAccessPolicy(crossinline block: UpdateAccessPolicyRequest.Builder.() -> Unit): UpdateAccessPolicyResponse = updateAccessPolicy(UpdateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Updates an asset's name. For more information, see [Updating assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html) in the *IoT SiteWise User Guide*.
 */
public suspend inline fun IotSiteWiseClient.updateAsset(crossinline block: UpdateAssetRequest.Builder.() -> Unit): UpdateAssetResponse = updateAsset(UpdateAssetRequest.Builder().apply(block).build())

/**
 * Updates an asset model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model's property and hierarchy definitions. For more information, see [Updating assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html) in the *IoT SiteWise User Guide*.
 *
 * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. You can’t change the type or data type of an existing property.
 *
 * To replace an existing asset model property with a new one with the same `name`, do the following:
 * + Submit an `UpdateAssetModel` request with the entire existing property removed.
 * + Submit a second `UpdateAssetModel` request that includes the new property. The new asset property will have the same `name` as the previous one and IoT SiteWise will generate a new unique `id`.
 */
public suspend inline fun IotSiteWiseClient.updateAssetModel(crossinline block: UpdateAssetModelRequest.Builder.() -> Unit): UpdateAssetModelResponse = updateAssetModel(UpdateAssetModelRequest.Builder().apply(block).build())

/**
 * Updates a composite model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model's property and hierarchy definitions. For more information, see [Updating assets and models](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html) in the *IoT SiteWise User Guide*.
 *
 * If you remove a property from a composite asset model, IoT SiteWise deletes all previous data for that property. You can’t change the type or data type of an existing property.
 *
 * To replace an existing composite asset model property with a new one with the same `name`, do the following:
 * + Submit an `UpdateAssetModelCompositeModel` request with the entire existing property removed.
 * + Submit a second `UpdateAssetModelCompositeModel` request that includes the new property. The new asset property will have the same `name` as the previous one and IoT SiteWise will generate a new unique `id`.
 */
public suspend inline fun IotSiteWiseClient.updateAssetModelCompositeModel(crossinline block: UpdateAssetModelCompositeModelRequest.Builder.() -> Unit): UpdateAssetModelCompositeModelResponse = updateAssetModelCompositeModel(UpdateAssetModelCompositeModelRequest.Builder().apply(block).build())

/**
 * Updates an asset property's alias and notification state.
 *
 * This operation overwrites the property's existing alias and notification state. To keep your existing property's alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more information, see [DescribeAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html).
 */
public suspend inline fun IotSiteWiseClient.updateAssetProperty(crossinline block: UpdateAssetPropertyRequest.Builder.() -> Unit): UpdateAssetPropertyResponse = updateAssetProperty(UpdateAssetPropertyRequest.Builder().apply(block).build())

/**
 * Updates the computation model.
 */
public suspend inline fun IotSiteWiseClient.updateComputationModel(crossinline block: UpdateComputationModelRequest.Builder.() -> Unit): UpdateComputationModelResponse = updateComputationModel(UpdateComputationModelRequest.Builder().apply(block).build())

/**
 * Updates an IoT SiteWise Monitor dashboard.
 */
public suspend inline fun IotSiteWiseClient.updateDashboard(crossinline block: UpdateDashboardRequest.Builder.() -> Unit): UpdateDashboardResponse = updateDashboard(UpdateDashboardRequest.Builder().apply(block).build())

/**
 * Updates a dataset.
 */
public suspend inline fun IotSiteWiseClient.updateDataset(crossinline block: UpdateDatasetRequest.Builder.() -> Unit): UpdateDatasetResponse = updateDataset(UpdateDatasetRequest.Builder().apply(block).build())

/**
 * Updates a gateway's name.
 */
public suspend inline fun IotSiteWiseClient.updateGateway(crossinline block: UpdateGatewayRequest.Builder.() -> Unit): UpdateGatewayResponse = updateGateway(UpdateGatewayRequest.Builder().apply(block).build())

/**
 * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability defines data sources for a gateway.
 *
 * Important workflow notes:
 *
 * Each gateway capability defines data sources for a gateway. This is the namespace of the gateway capability.
 *
 * . The namespace follows the format `service:capability:version`, where:
 * + `service` - The service providing the capability, or `iotsitewise`.
 * + `capability` - The specific capability type. Options include: `opcuacollector` for the OPC UA data source collector, or `publisher` for data publisher capability.
 * + `version` - The version number of the capability. Option include `2` for Classic streams, V2 gateways, and `3` for MQTT-enabled, V3 gateways.
 *
 * After updating a capability configuration, the sync status becomes `OUT_OF_SYNC` until the gateway processes the configuration.Use `DescribeGatewayCapabilityConfiguration` to check the sync status and verify the configuration was applied.
 *
 * A gateway can have multiple capability configurations with different namespaces.
 */
public suspend inline fun IotSiteWiseClient.updateGatewayCapabilityConfiguration(crossinline block: UpdateGatewayCapabilityConfigurationRequest.Builder.() -> Unit): UpdateGatewayCapabilityConfigurationResponse = updateGatewayCapabilityConfiguration(UpdateGatewayCapabilityConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an IoT SiteWise Monitor portal.
 */
public suspend inline fun IotSiteWiseClient.updatePortal(crossinline block: UpdatePortalRequest.Builder.() -> Unit): UpdatePortalResponse = updatePortal(UpdatePortalRequest.Builder().apply(block).build())

/**
 * Updates an IoT SiteWise Monitor project.
 */
public suspend inline fun IotSiteWiseClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())
