// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.waiters

import aws.sdk.kotlin.services.iotsitewise.IotSiteWiseClient
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.DescribePortalRequest
import aws.sdk.kotlin.services.iotsitewise.model.DescribePortalResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun IotSiteWiseClient.waitUntilAssetActive(request: DescribeAssetRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeAssetResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeAssetRequest, DescribeAssetResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val assetStatus = it.assetStatus
            val state = assetStatus?.state?.value
            state == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val assetStatus = it.assetStatus
            val state = assetStatus?.state?.value
            state == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAsset(request) }
}

public suspend fun IotSiteWiseClient.waitUntilAssetActive(block: DescribeAssetRequest.Builder.() -> Unit): Outcome<DescribeAssetResponse> =
    waitUntilAssetActive(DescribeAssetRequest.Builder().apply(block).build())

public suspend fun IotSiteWiseClient.waitUntilAssetNotExists(request: DescribeAssetRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeAssetResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeAssetRequest, DescribeAssetResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAsset(request) }
}

public suspend fun IotSiteWiseClient.waitUntilAssetNotExists(block: DescribeAssetRequest.Builder.() -> Unit): Outcome<DescribeAssetResponse> =
    waitUntilAssetNotExists(DescribeAssetRequest.Builder().apply(block).build())

public suspend fun IotSiteWiseClient.waitUntilAssetModelActive(request: DescribeAssetModelRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeAssetModelResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeAssetModelRequest, DescribeAssetModelResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val assetModelStatus = it.assetModelStatus
            val state = assetModelStatus?.state?.value
            state == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val assetModelStatus = it.assetModelStatus
            val state = assetModelStatus?.state?.value
            state == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAssetModel(request) }
}

public suspend fun IotSiteWiseClient.waitUntilAssetModelActive(block: DescribeAssetModelRequest.Builder.() -> Unit): Outcome<DescribeAssetModelResponse> =
    waitUntilAssetModelActive(DescribeAssetModelRequest.Builder().apply(block).build())

public suspend fun IotSiteWiseClient.waitUntilAssetModelNotExists(request: DescribeAssetModelRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeAssetModelResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeAssetModelRequest, DescribeAssetModelResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAssetModel(request) }
}

public suspend fun IotSiteWiseClient.waitUntilAssetModelNotExists(block: DescribeAssetModelRequest.Builder.() -> Unit): Outcome<DescribeAssetModelResponse> =
    waitUntilAssetModelNotExists(DescribeAssetModelRequest.Builder().apply(block).build())

public suspend fun IotSiteWiseClient.waitUntilPortalActive(request: DescribePortalRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribePortalResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribePortalRequest, DescribePortalResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val portalStatus = it.portalStatus
            val state = portalStatus?.state?.value
            state == "ACTIVE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describePortal(request) }
}

public suspend fun IotSiteWiseClient.waitUntilPortalActive(block: DescribePortalRequest.Builder.() -> Unit): Outcome<DescribePortalResponse> =
    waitUntilPortalActive(DescribePortalRequest.Builder().apply(block).build())

public suspend fun IotSiteWiseClient.waitUntilPortalNotExists(request: DescribePortalRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribePortalResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribePortalRequest, DescribePortalResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describePortal(request) }
}

public suspend fun IotSiteWiseClient.waitUntilPortalNotExists(block: DescribePortalRequest.Builder.() -> Unit): Outcome<DescribePortalResponse> =
    waitUntilPortalNotExists(DescribePortalRequest.Builder().apply(block).build())
