// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.Alarms
import aws.sdk.kotlin.services.iotsitewise.model.Image
import aws.sdk.kotlin.services.iotsitewise.model.PortalType
import aws.sdk.kotlin.services.iotsitewise.model.PortalTypeEntry
import aws.sdk.kotlin.services.iotsitewise.model.UpdatePortalRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdatePortalOperationSerializer: HttpSerializer.NonStreaming<UpdatePortalRequest> {
    override fun serialize(context: ExecutionContext, input: UpdatePortalRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.portalId) { "portalId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("portals"))
                add(PercentEncoding.SmithyLabel.encode(input.portalId))
            }
        }

        val payload = serializeUpdatePortalOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdatePortalOperationBody(context: ExecutionContext, input: UpdatePortalRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarms"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val NOTIFICATIONSENDEREMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notificationSenderEmail"))
    val PORTALCONTACTEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalContactEmail"))
    val PORTALDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalDescription"))
    val PORTALLOGOIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalLogoImage"))
    val PORTALNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalName"))
    val PORTALTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("portalType"))
    val PORTALTYPECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("portalTypeConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(NOTIFICATIONSENDEREMAIL_DESCRIPTOR)
        field(PORTALCONTACTEMAIL_DESCRIPTOR)
        field(PORTALDESCRIPTION_DESCRIPTOR)
        field(PORTALLOGOIMAGE_DESCRIPTOR)
        field(PORTALNAME_DESCRIPTOR)
        field(PORTALTYPE_DESCRIPTOR)
        field(PORTALTYPECONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alarms?.let { field(ALARMS_DESCRIPTOR, it, ::serializeAlarmsDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.notificationSenderEmail?.let { field(NOTIFICATIONSENDEREMAIL_DESCRIPTOR, it) }
        input.portalContactEmail?.let { field(PORTALCONTACTEMAIL_DESCRIPTOR, it) }
        input.portalDescription?.let { field(PORTALDESCRIPTION_DESCRIPTOR, it) }
        input.portalLogoImage?.let { field(PORTALLOGOIMAGE_DESCRIPTOR, it, ::serializeImageDocument) }
        input.portalName?.let { field(PORTALNAME_DESCRIPTOR, it) }
        input.portalType?.let { field(PORTALTYPE_DESCRIPTOR, it.value) }
        if (input.portalTypeConfiguration != null) {
            mapField(PORTALTYPECONFIGURATION_DESCRIPTOR) {
                input.portalTypeConfiguration.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializePortalTypeEntryDocument)) }
            }
        }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
