// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.AssetModelCompositeModel
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelHierarchy
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelProperty
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelVersionType
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetModelRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAssetModelOperationSerializer: HttpSerializer.NonStreaming<UpdateAssetModelRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAssetModelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.assetModelId) { "assetModelId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("asset-models"))
                add(PercentEncoding.SmithyLabel.encode(input.assetModelId))
            }
        }

        builder.headers {
            if (input.ifMatch != null) append("If-Match", input.ifMatch)
            if (input.ifNoneMatch != null) append("If-None-Match", input.ifNoneMatch)
            if (input.matchForVersionType != null) append("Match-For-Version-Type", input.matchForVersionType.value)
        }

        val payload = serializeUpdateAssetModelOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAssetModelOperationBody(context: ExecutionContext, input: UpdateAssetModelRequest): ByteArray {
    val serializer = JsonSerializer()
    val ASSETMODELCOMPOSITEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModels"))
    val ASSETMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelDescription"))
    val ASSETMODELEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelExternalId"))
    val ASSETMODELHIERARCHIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelHierarchies"))
    val ASSETMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelName"))
    val ASSETMODELPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelProperties"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETMODELCOMPOSITEMODELS_DESCRIPTOR)
        field(ASSETMODELDESCRIPTION_DESCRIPTOR)
        field(ASSETMODELEXTERNALID_DESCRIPTOR)
        field(ASSETMODELHIERARCHIES_DESCRIPTOR)
        field(ASSETMODELNAME_DESCRIPTOR)
        field(ASSETMODELPROPERTIES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.assetModelCompositeModels != null) {
            listField(ASSETMODELCOMPOSITEMODELS_DESCRIPTOR) {
                for (el0 in input.assetModelCompositeModels) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssetModelCompositeModelDocument))
                }
            }
        }
        input.assetModelDescription?.let { field(ASSETMODELDESCRIPTION_DESCRIPTOR, it) }
        input.assetModelExternalId?.let { field(ASSETMODELEXTERNALID_DESCRIPTOR, it) }
        if (input.assetModelHierarchies != null) {
            listField(ASSETMODELHIERARCHIES_DESCRIPTOR) {
                for (el0 in input.assetModelHierarchies) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssetModelHierarchyDocument))
                }
            }
        }
        input.assetModelName?.let { field(ASSETMODELNAME_DESCRIPTOR, it) }
        if (input.assetModelProperties != null) {
            listField(ASSETMODELPROPERTIES_DESCRIPTOR) {
                for (el0 in input.assetModelProperties) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssetModelPropertyDocument))
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
    }
    return serializer.toByteArray()
}
