// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.InvokeAssistantResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.ResponseStream
import aws.smithy.kotlin.runtime.ClientException
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class InvokeAssistantOperationDeserializer: HttpDeserializer.Streaming<InvokeAssistantResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvokeAssistantResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwInvokeAssistantError(context, call, payload)
        }
        val builder = InvokeAssistantResponse.Builder()

        builder.conversationId = response.headers["x-amz-iotsitewise-assistant-conversation-id"]

        deserializeInvokeAssistantOperationBody(builder, call)
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInvokeAssistantError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeInvokeAssistantOperationBody(builder: InvokeAssistantResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val events = frames
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "trace" -> {
                        val e = deserializeTracePayload(message.payload)
                        ResponseStream.Trace(e)
                    }
                    "output" -> {
                        val e = deserializeInvocationOutputPayload(message.payload)
                        ResponseStream.Output(e)
                    }
                    else -> ResponseStream.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    "accessDeniedException" -> {
                        val err = deserializeAccessDeniedExceptionPayload(message.payload)
                        throw err
                    }
                    "conflictingOperationException" -> {
                        val err = deserializeConflictingOperationExceptionPayload(message.payload)
                        throw err
                    }
                    "internalFailureException" -> {
                        val err = deserializeInternalFailureExceptionPayload(message.payload)
                        throw err
                    }
                    "invalidRequestException" -> {
                        val err = deserializeInvalidRequestExceptionPayload(message.payload)
                        throw err
                    }
                    "limitExceededException" -> {
                        val err = deserializeLimitExceededExceptionPayload(message.payload)
                        throw err
                    }
                    "resourceNotFoundException" -> {
                        val err = deserializeResourceNotFoundExceptionPayload(message.payload)
                        throw err
                    }
                    "throttlingException" -> {
                        val err = deserializeThrottlingExceptionPayload(message.payload)
                        throw err
                    }
                    else -> throw IotSiteWiseException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw IotSiteWiseException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.body = events
}
