// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeProjectOperationDeserializer: HttpDeserializer.NonStreaming<DescribeProjectResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeProjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProjectError(context, call, payload)
        }
        val builder = DescribeProjectResponse.Builder()

        if (payload != null) {
            deserializeDescribeProjectOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeProjectError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProjectOperationBody(builder: DescribeProjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PORTALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalId"))
    val PROJECTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectArn"))
    val PROJECTCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("projectCreationDate"))
    val PROJECTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectDescription"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val PROJECTLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("projectLastUpdateDate"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PORTALID_DESCRIPTOR)
        field(PROJECTARN_DESCRIPTOR)
        field(PROJECTCREATIONDATE_DESCRIPTOR)
        field(PROJECTDESCRIPTION_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(PROJECTLASTUPDATEDATE_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PORTALID_DESCRIPTOR.index -> builder.portalId = deserializeString()
                PROJECTARN_DESCRIPTOR.index -> builder.projectArn = deserializeString()
                PROJECTCREATIONDATE_DESCRIPTOR.index -> builder.projectCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PROJECTDESCRIPTION_DESCRIPTOR.index -> builder.projectDescription = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                PROJECTLASTUPDATEDATE_DESCRIPTOR.index -> builder.projectLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
