// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayResponse
import aws.sdk.kotlin.services.iotsitewise.model.GatewayCapabilitySummary
import aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeGatewayOperationDeserializer: HttpDeserializer.NonStreaming<DescribeGatewayResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeGatewayResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeGatewayError(context, call, payload)
        }
        val builder = DescribeGatewayResponse.Builder()

        if (payload != null) {
            deserializeDescribeGatewayOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeGatewayError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGatewayOperationBody(builder: DescribeGatewayResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayArn"))
    val GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("gatewayCapabilitySummaries"))
    val GATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayId"))
    val GATEWAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayName"))
    val GATEWAYPLATFORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("gatewayPlatform"))
    val GATEWAYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayVersion"))
    val LASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdateDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
        field(GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR)
        field(GATEWAYID_DESCRIPTOR)
        field(GATEWAYNAME_DESCRIPTOR)
        field(GATEWAYPLATFORM_DESCRIPTOR)
        field(GATEWAYVERSION_DESCRIPTOR)
        field(LASTUPDATEDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR.index -> builder.gatewayCapabilitySummaries =
                    deserializer.deserializeList(GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<GatewayCapabilitySummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGatewayCapabilitySummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GATEWAYID_DESCRIPTOR.index -> builder.gatewayId = deserializeString()
                GATEWAYNAME_DESCRIPTOR.index -> builder.gatewayName = deserializeString()
                GATEWAYPLATFORM_DESCRIPTOR.index -> builder.gatewayPlatform = deserializeGatewayPlatformDocument(deserializer)
                GATEWAYVERSION_DESCRIPTOR.index -> builder.gatewayVersion = deserializeString()
                LASTUPDATEDATE_DESCRIPTOR.index -> builder.lastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
