// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.AssetModelCompositeModel
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelCompositeModelSummary
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelHierarchy
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelProperty
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelType
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.InterfaceRelationship
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeAssetModelOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetModelError(context, call, payload)
        }
        val builder = DescribeAssetModelResponse.Builder()

        builder.eTag = response.headers["ETag"]

        if (payload != null) {
            deserializeDescribeAssetModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetModelOperationBody(builder: DescribeAssetModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelArn"))
    val ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModelSummaries"))
    val ASSETMODELCOMPOSITEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModels"))
    val ASSETMODELCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetModelCreationDate"))
    val ASSETMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelDescription"))
    val ASSETMODELEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelExternalId"))
    val ASSETMODELHIERARCHIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelHierarchies"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val ASSETMODELLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetModelLastUpdateDate"))
    val ASSETMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelName"))
    val ASSETMODELPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelProperties"))
    val ASSETMODELSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetModelStatus"))
    val ASSETMODELTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("assetModelType"))
    val ASSETMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelVersion"))
    val INTERFACEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("interfaceDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETMODELARN_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELS_DESCRIPTOR)
        field(ASSETMODELCREATIONDATE_DESCRIPTOR)
        field(ASSETMODELDESCRIPTION_DESCRIPTOR)
        field(ASSETMODELEXTERNALID_DESCRIPTOR)
        field(ASSETMODELHIERARCHIES_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(ASSETMODELLASTUPDATEDATE_DESCRIPTOR)
        field(ASSETMODELNAME_DESCRIPTOR)
        field(ASSETMODELPROPERTIES_DESCRIPTOR)
        field(ASSETMODELSTATUS_DESCRIPTOR)
        field(ASSETMODELTYPE_DESCRIPTOR)
        field(ASSETMODELVERSION_DESCRIPTOR)
        field(INTERFACEDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETMODELARN_DESCRIPTOR.index -> builder.assetModelArn = deserializeString()
                ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR.index -> builder.assetModelCompositeModelSummaries =
                    deserializer.deserializeList(ASSETMODELCOMPOSITEMODELSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelCompositeModelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelCompositeModelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCOMPOSITEMODELS_DESCRIPTOR.index -> builder.assetModelCompositeModels =
                    deserializer.deserializeList(ASSETMODELCOMPOSITEMODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelCompositeModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelCompositeModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCREATIONDATE_DESCRIPTOR.index -> builder.assetModelCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ASSETMODELDESCRIPTION_DESCRIPTOR.index -> builder.assetModelDescription = deserializeString()
                ASSETMODELEXTERNALID_DESCRIPTOR.index -> builder.assetModelExternalId = deserializeString()
                ASSETMODELHIERARCHIES_DESCRIPTOR.index -> builder.assetModelHierarchies =
                    deserializer.deserializeList(ASSETMODELHIERARCHIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelHierarchy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelHierarchyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                ASSETMODELLASTUPDATEDATE_DESCRIPTOR.index -> builder.assetModelLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ASSETMODELNAME_DESCRIPTOR.index -> builder.assetModelName = deserializeString()
                ASSETMODELPROPERTIES_DESCRIPTOR.index -> builder.assetModelProperties =
                    deserializer.deserializeList(ASSETMODELPROPERTIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelProperty>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelPropertyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELSTATUS_DESCRIPTOR.index -> builder.assetModelStatus = deserializeAssetModelStatusDocument(deserializer)
                ASSETMODELTYPE_DESCRIPTOR.index -> builder.assetModelType = deserializeString().let { AssetModelType.fromValue(it) }
                ASSETMODELVERSION_DESCRIPTOR.index -> builder.assetModelVersion = deserializeString()
                INTERFACEDETAILS_DESCRIPTOR.index -> builder.interfaceDetails =
                    deserializer.deserializeList(INTERFACEDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<InterfaceRelationship>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInterfaceRelationshipDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
