// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelInterfaceRelationshipResponse
import aws.sdk.kotlin.services.iotsitewise.model.HierarchyMapping
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.PropertyMapping
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeAssetModelInterfaceRelationshipOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetModelInterfaceRelationshipResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetModelInterfaceRelationshipResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetModelInterfaceRelationshipError(context, call, payload)
        }
        val builder = DescribeAssetModelInterfaceRelationshipResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetModelInterfaceRelationshipOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetModelInterfaceRelationshipError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetModelInterfaceRelationshipOperationBody(builder: DescribeAssetModelInterfaceRelationshipResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val HIERARCHYMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hierarchyMappings"))
    val INTERFACEASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("interfaceAssetModelId"))
    val PROPERTYMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("propertyMappings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETMODELID_DESCRIPTOR)
        field(HIERARCHYMAPPINGS_DESCRIPTOR)
        field(INTERFACEASSETMODELID_DESCRIPTOR)
        field(PROPERTYMAPPINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                HIERARCHYMAPPINGS_DESCRIPTOR.index -> builder.hierarchyMappings =
                    deserializer.deserializeList(HIERARCHYMAPPINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<HierarchyMapping>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHierarchyMappingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INTERFACEASSETMODELID_DESCRIPTOR.index -> builder.interfaceAssetModelId = deserializeString()
                PROPERTYMAPPINGS_DESCRIPTOR.index -> builder.propertyMappings =
                    deserializer.deserializeList(PROPERTYMAPPINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<PropertyMapping>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePropertyMappingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
