// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.ActionDefinition
import aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelPathSegment
import aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModelSummary
import aws.sdk.kotlin.services.iotsitewise.model.AssetProperty
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetCompositeModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeAssetCompositeModelOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetCompositeModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetCompositeModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetCompositeModelError(context, call, payload)
        }
        val builder = DescribeAssetCompositeModelResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetCompositeModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetCompositeModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetCompositeModelOperationBody(builder: DescribeAssetCompositeModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actionDefinitions"))
    val ASSETCOMPOSITEMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetCompositeModelDescription"))
    val ASSETCOMPOSITEMODELEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetCompositeModelExternalId"))
    val ASSETCOMPOSITEMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetCompositeModelId"))
    val ASSETCOMPOSITEMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetCompositeModelName"))
    val ASSETCOMPOSITEMODELPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetCompositeModelPath"))
    val ASSETCOMPOSITEMODELPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetCompositeModelProperties"))
    val ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetCompositeModelSummaries"))
    val ASSETCOMPOSITEMODELTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetCompositeModelType"))
    val ASSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONDEFINITIONS_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELDESCRIPTION_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELEXTERNALID_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELID_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELNAME_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELPATH_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELPROPERTIES_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELTYPE_DESCRIPTOR)
        field(ASSETID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONDEFINITIONS_DESCRIPTOR.index -> builder.actionDefinitions =
                    deserializer.deserializeList(ACTIONDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActionDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActionDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCOMPOSITEMODELDESCRIPTION_DESCRIPTOR.index -> builder.assetCompositeModelDescription = deserializeString()
                ASSETCOMPOSITEMODELEXTERNALID_DESCRIPTOR.index -> builder.assetCompositeModelExternalId = deserializeString()
                ASSETCOMPOSITEMODELID_DESCRIPTOR.index -> builder.assetCompositeModelId = deserializeString()
                ASSETCOMPOSITEMODELNAME_DESCRIPTOR.index -> builder.assetCompositeModelName = deserializeString()
                ASSETCOMPOSITEMODELPATH_DESCRIPTOR.index -> builder.assetCompositeModelPath =
                    deserializer.deserializeList(ASSETCOMPOSITEMODELPATH_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetCompositeModelPathSegment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetCompositeModelPathSegmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCOMPOSITEMODELPROPERTIES_DESCRIPTOR.index -> builder.assetCompositeModelProperties =
                    deserializer.deserializeList(ASSETCOMPOSITEMODELPROPERTIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetProperty>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetPropertyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR.index -> builder.assetCompositeModelSummaries =
                    deserializer.deserializeList(ASSETCOMPOSITEMODELSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetCompositeModelSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetCompositeModelSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCOMPOSITEMODELTYPE_DESCRIPTOR.index -> builder.assetCompositeModelType = deserializeString()
                ASSETID_DESCRIPTOR.index -> builder.assetId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
