// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeAccessPolicyResponse
import aws.sdk.kotlin.services.iotsitewise.model.Identity
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.Permission
import aws.sdk.kotlin.services.iotsitewise.model.Resource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAccessPolicyOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAccessPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAccessPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAccessPolicyError(context, call, payload)
        }
        val builder = DescribeAccessPolicyResponse.Builder()

        if (payload != null) {
            deserializeDescribeAccessPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAccessPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccessPolicyOperationBody(builder: DescribeAccessPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSPOLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessPolicyArn"))
    val ACCESSPOLICYCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("accessPolicyCreationDate"))
    val ACCESSPOLICYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessPolicyId"))
    val ACCESSPOLICYIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyIdentity"))
    val ACCESSPOLICYLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("accessPolicyLastUpdateDate"))
    val ACCESSPOLICYPERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("accessPolicyPermission"))
    val ACCESSPOLICYRESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyResource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSPOLICYARN_DESCRIPTOR)
        field(ACCESSPOLICYCREATIONDATE_DESCRIPTOR)
        field(ACCESSPOLICYID_DESCRIPTOR)
        field(ACCESSPOLICYIDENTITY_DESCRIPTOR)
        field(ACCESSPOLICYLASTUPDATEDATE_DESCRIPTOR)
        field(ACCESSPOLICYPERMISSION_DESCRIPTOR)
        field(ACCESSPOLICYRESOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSPOLICYARN_DESCRIPTOR.index -> builder.accessPolicyArn = deserializeString()
                ACCESSPOLICYCREATIONDATE_DESCRIPTOR.index -> builder.accessPolicyCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ACCESSPOLICYID_DESCRIPTOR.index -> builder.accessPolicyId = deserializeString()
                ACCESSPOLICYIDENTITY_DESCRIPTOR.index -> builder.accessPolicyIdentity = deserializeIdentityDocument(deserializer)
                ACCESSPOLICYLASTUPDATEDATE_DESCRIPTOR.index -> builder.accessPolicyLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ACCESSPOLICYPERMISSION_DESCRIPTOR.index -> builder.accessPolicyPermission = deserializeString().let { Permission.fromValue(it) }
                ACCESSPOLICYRESOURCE_DESCRIPTOR.index -> builder.accessPolicyResource = deserializeResourceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
