// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.Alarms
import aws.sdk.kotlin.services.iotsitewise.model.AuthMode
import aws.sdk.kotlin.services.iotsitewise.model.CreatePortalRequest
import aws.sdk.kotlin.services.iotsitewise.model.ImageFile
import aws.sdk.kotlin.services.iotsitewise.model.PortalType
import aws.sdk.kotlin.services.iotsitewise.model.PortalTypeEntry
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePortalOperationSerializer: HttpSerializer.NonStreaming<CreatePortalRequest> {
    override fun serialize(context: ExecutionContext, input: CreatePortalRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/portals"
        }

        val payload = serializeCreatePortalOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreatePortalOperationBody(context: ExecutionContext, input: CreatePortalRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarms"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val NOTIFICATIONSENDEREMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notificationSenderEmail"))
    val PORTALAUTHMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("portalAuthMode"))
    val PORTALCONTACTEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalContactEmail"))
    val PORTALDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalDescription"))
    val PORTALLOGOIMAGEFILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalLogoImageFile"))
    val PORTALNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalName"))
    val PORTALTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("portalType"))
    val PORTALTYPECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("portalTypeConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(NOTIFICATIONSENDEREMAIL_DESCRIPTOR)
        field(PORTALAUTHMODE_DESCRIPTOR)
        field(PORTALCONTACTEMAIL_DESCRIPTOR)
        field(PORTALDESCRIPTION_DESCRIPTOR)
        field(PORTALLOGOIMAGEFILE_DESCRIPTOR)
        field(PORTALNAME_DESCRIPTOR)
        field(PORTALTYPE_DESCRIPTOR)
        field(PORTALTYPECONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alarms?.let { field(ALARMS_DESCRIPTOR, it, ::serializeAlarmsDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.notificationSenderEmail?.let { field(NOTIFICATIONSENDEREMAIL_DESCRIPTOR, it) }
        input.portalAuthMode?.let { field(PORTALAUTHMODE_DESCRIPTOR, it.value) }
        input.portalContactEmail?.let { field(PORTALCONTACTEMAIL_DESCRIPTOR, it) }
        input.portalDescription?.let { field(PORTALDESCRIPTION_DESCRIPTOR, it) }
        input.portalLogoImageFile?.let { field(PORTALLOGOIMAGEFILE_DESCRIPTOR, it, ::serializeImageFileDocument) }
        input.portalName?.let { field(PORTALNAME_DESCRIPTOR, it) }
        input.portalType?.let { field(PORTALTYPE_DESCRIPTOR, it.value) }
        if (input.portalTypeConfiguration != null) {
            mapField(PORTALTYPECONFIGURATION_DESCRIPTOR) {
                input.portalTypeConfiguration.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializePortalTypeEntryDocument)) }
            }
        }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
