// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.PortalStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePortalOperationDeserializer: HttpDeserializer.NonStreaming<CreatePortalResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreatePortalResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreatePortalError(context, call, payload)
        }
        val builder = CreatePortalResponse.Builder()

        if (payload != null) {
            deserializeCreatePortalOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreatePortalError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePortalOperationBody(builder: CreatePortalResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PORTALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalArn"))
    val PORTALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalId"))
    val PORTALSTARTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalStartUrl"))
    val PORTALSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalStatus"))
    val SSOAPPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ssoApplicationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PORTALARN_DESCRIPTOR)
        field(PORTALID_DESCRIPTOR)
        field(PORTALSTARTURL_DESCRIPTOR)
        field(PORTALSTATUS_DESCRIPTOR)
        field(SSOAPPLICATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PORTALARN_DESCRIPTOR.index -> builder.portalArn = deserializeString()
                PORTALID_DESCRIPTOR.index -> builder.portalId = deserializeString()
                PORTALSTARTURL_DESCRIPTOR.index -> builder.portalStartUrl = deserializeString()
                PORTALSTATUS_DESCRIPTOR.index -> builder.portalStatus = deserializePortalStatusDocument(deserializer)
                SSOAPPLICATIONID_DESCRIPTOR.index -> builder.ssoApplicationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
