// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.CreateDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDashboardOperationDeserializer: HttpDeserializer.NonStreaming<CreateDashboardResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDashboardResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDashboardError(context, call, payload)
        }
        val builder = CreateDashboardResponse.Builder()

        if (payload != null) {
            deserializeCreateDashboardOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDashboardError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDashboardOperationBody(builder: CreateDashboardResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DASHBOARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardArn"))
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDARN_DESCRIPTOR)
        field(DASHBOARDID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DASHBOARDARN_DESCRIPTOR.index -> builder.dashboardArn = deserializeString()
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
