// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAssetPropertyRequest private constructor(builder: Builder) {
    /**
     * The ID of the asset to be updated. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     *
     * If you omit this parameter, the alias is removed from the property.
     */
    public val propertyAlias: kotlin.String? = builder.propertyAlias
    /**
     * The ID of the asset property to be updated. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val propertyId: kotlin.String? = builder.propertyId
    /**
     * The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see [Interacting with other services](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html) in the *IoT SiteWise User Guide*.
     *
     * If you omit this parameter, the notification state is set to `DISABLED`.
     */
    public val propertyNotificationState: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotificationState? = builder.propertyNotificationState
    /**
     * The unit of measure (such as Newtons or RPM) of the asset property. If you don't specify a value for this parameter, the service uses the value of the `assetModelProperty` in the asset model.
     */
    public val propertyUnit: kotlin.String? = builder.propertyUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAssetPropertyRequest(")
        append("assetId=$assetId,")
        append("clientToken=$clientToken,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("propertyNotificationState=$propertyNotificationState,")
        append("propertyUnit=$propertyUnit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (propertyNotificationState?.hashCode() ?: 0)
        result = 31 * result + (propertyUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAssetPropertyRequest

        if (assetId != other.assetId) return false
        if (clientToken != other.clientToken) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (propertyNotificationState != other.propertyNotificationState) return false
        if (propertyUnit != other.propertyUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset to be updated. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetId: kotlin.String? = null
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         *
         * If you omit this parameter, the alias is removed from the property.
         */
        public var propertyAlias: kotlin.String? = null
        /**
         * The ID of the asset property to be updated. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var propertyId: kotlin.String? = null
        /**
         * The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see [Interacting with other services](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html) in the *IoT SiteWise User Guide*.
         *
         * If you omit this parameter, the notification state is set to `DISABLED`.
         */
        public var propertyNotificationState: aws.sdk.kotlin.services.iotsitewise.model.PropertyNotificationState? = null
        /**
         * The unit of measure (such as Newtons or RPM) of the asset property. If you don't specify a value for this parameter, the service uses the value of the `assetModelProperty` in the asset model.
         */
        public var propertyUnit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyRequest) : this() {
            this.assetId = x.assetId
            this.clientToken = x.clientToken
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.propertyNotificationState = x.propertyNotificationState
            this.propertyUnit = x.propertyUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyRequest = UpdateAssetPropertyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
