// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a list of value updates for an asset property in the list of asset entries consumed by the [BatchPutAssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html) API operation.
 */
public class PutAssetPropertyValueEntry private constructor(builder: Builder) {
    /**
     * The ID of the asset to update.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The user specified ID for the entry. You can use this ID to identify which entries failed.
     */
    public val entryId: kotlin.String = requireNotNull(builder.entryId) { "A non-null value must be provided for entryId" }
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     */
    public val propertyAlias: kotlin.String? = builder.propertyAlias
    /**
     * The ID of the asset property for this entry.
     */
    public val propertyId: kotlin.String? = builder.propertyId
    /**
     * The list of property values to upload. You can specify up to 10 `propertyValues` array elements.
     */
    public val propertyValues: List<AssetPropertyValue> = requireNotNull(builder.propertyValues) { "A non-null value must be provided for propertyValues" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.PutAssetPropertyValueEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAssetPropertyValueEntry(")
        append("assetId=$assetId,")
        append("entryId=$entryId,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("propertyValues=$propertyValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (entryId.hashCode())
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (propertyValues.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAssetPropertyValueEntry

        if (assetId != other.assetId) return false
        if (entryId != other.entryId) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (propertyValues != other.propertyValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.PutAssetPropertyValueEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset to update.
         */
        public var assetId: kotlin.String? = null
        /**
         * The user specified ID for the entry. You can use this ID to identify which entries failed.
         */
        public var entryId: kotlin.String? = null
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         */
        public var propertyAlias: kotlin.String? = null
        /**
         * The ID of the asset property for this entry.
         */
        public var propertyId: kotlin.String? = null
        /**
         * The list of property values to upload. You can specify up to 10 `propertyValues` array elements.
         */
        public var propertyValues: List<AssetPropertyValue>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.PutAssetPropertyValueEntry) : this() {
            this.assetId = x.assetId
            this.entryId = x.entryId
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.propertyValues = x.propertyValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.PutAssetPropertyValueEntry = PutAssetPropertyValueEntry(this)

        internal fun correctErrors(): Builder {
            if (entryId == null) entryId = ""
            if (propertyValues == null) propertyValues = emptyList()
            return this
        }
    }
}
