// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAssetRelationshipsRequest private constructor(builder: Builder) {
    /**
     * The ID of the asset. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The maximum number of results to return for each paginated request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of traversal to use to identify asset relationships. Choose the following option:
     * + `PATH_TO_ROOT` – Identify the asset's parent assets up to the root asset. The asset that you specify in `assetId` is the first result in the list of `assetRelationshipSummaries`, and the root asset is the last result.
     */
    public val traversalType: aws.sdk.kotlin.services.iotsitewise.model.TraversalType? = builder.traversalType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ListAssetRelationshipsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssetRelationshipsRequest(")
        append("assetId=$assetId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("traversalType=$traversalType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (traversalType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAssetRelationshipsRequest

        if (assetId != other.assetId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (traversalType != other.traversalType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ListAssetRelationshipsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetId: kotlin.String? = null
        /**
         * The maximum number of results to return for each paginated request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of traversal to use to identify asset relationships. Choose the following option:
         * + `PATH_TO_ROOT` – Identify the asset's parent assets up to the root asset. The asset that you specify in `assetId` is the first result in the list of `assetRelationshipSummaries`, and the root asset is the last result.
         */
        public var traversalType: aws.sdk.kotlin.services.iotsitewise.model.TraversalType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ListAssetRelationshipsRequest) : this() {
            this.assetId = x.assetId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.traversalType = x.traversalType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ListAssetRelationshipsRequest = ListAssetRelationshipsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
