// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the job summary information.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The ID of the job.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The unique name that helps identify the job request.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the bulk import job can be one of following values:
     * + `PENDING` – IoT SiteWise is waiting for the current bulk import job to finish.
     * + `CANCELLED` – The bulk import job has been canceled.
     * + `RUNNING` – IoT SiteWise is processing your request to import your data from Amazon S3.
     * + `COMPLETED` – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * + `FAILED` – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * + `COMPLETED_WITH_FAILURES` – IoT SiteWise completed your request to import data from Amazon S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     */
    public val status: aws.sdk.kotlin.services.iotsitewise.model.JobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("id=$id,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.JobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the job.
         */
        public var id: kotlin.String? = null
        /**
         * The unique name that helps identify the job request.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the bulk import job can be one of following values:
         * + `PENDING` – IoT SiteWise is waiting for the current bulk import job to finish.
         * + `CANCELLED` – The bulk import job has been canceled.
         * + `RUNNING` – IoT SiteWise is processing your request to import your data from Amazon S3.
         * + `COMPLETED` – IoT SiteWise successfully completed your request to import data from Amazon S3.
         * + `FAILED` – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * + `COMPLETED_WITH_FAILURES` – IoT SiteWise completed your request to import data from Amazon S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         */
        public var status: aws.sdk.kotlin.services.iotsitewise.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.JobSummary) : this() {
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.JobSummary = JobSummary(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (name == null) name = ""
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
