// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetInterpolatedAssetPropertyValuesRequest private constructor(builder: Builder) {
    /**
     * The ID of the asset, in UUID format.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.
     */
    public val endTimeInSeconds: kotlin.Long? = builder.endTimeInSeconds
    /**
     * The nanosecond offset converted from `endTimeInSeconds`.
     */
    public val endTimeOffsetInNanos: kotlin.Int? = builder.endTimeOffsetInNanos
    /**
     * The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.
     */
    public val intervalInSeconds: kotlin.Long? = builder.intervalInSeconds
    /**
     * The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval, minus the window to the timestamp of each interval plus the window. If not specified, the window ranges between the start time minus the interval and the end time plus the interval.
     *
     * + If you specify a value for the `intervalWindowInSeconds` parameter, the value for the `type` parameter must be `LINEAR_INTERPOLATION`.
     * + If a data point isn't found during the specified query window, IoT SiteWise won't return an interpolated value for the interval. This indicates that there's a gap in the ingested data points.
     * For example, you can get the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to compute the second interpolated value, and so on.
     */
    public val intervalWindowInSeconds: kotlin.Long? = builder.intervalWindowInSeconds
    /**
     * The maximum number of results to return for each paginated request. If not specified, the default value is 10.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     */
    public val propertyAlias: kotlin.String? = builder.propertyAlias
    /**
     * The ID of the asset property, in UUID format.
     */
    public val propertyId: kotlin.String? = builder.propertyId
    /**
     * The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.
     */
    public val quality: aws.sdk.kotlin.services.iotsitewise.model.Quality? = builder.quality
    /**
     * The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.
     */
    public val startTimeInSeconds: kotlin.Long? = builder.startTimeInSeconds
    /**
     * The nanosecond offset converted from `startTimeInSeconds`.
     */
    public val startTimeOffsetInNanos: kotlin.Int? = builder.startTimeOffsetInNanos
    /**
     * The interpolation type.
     *
     * Valid values: `LINEAR_INTERPOLATION | LOCF_INTERPOLATION`
     * + `LINEAR_INTERPOLATION` – Estimates missing data using [linear interpolation](https://en.wikipedia.org/wiki/Linear_interpolation).For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value on July 3, 2021, at 9 AM, and so on.
     * + `LOCF_INTERPOLATION` – Estimates missing data using last observation carried forward interpolationIf no data point is found for an interval, IoT SiteWise returns the last observed data point for the previous interval and carries forward this interpolated value until a new data point is found.For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetInterpolatedAssetPropertyValuesRequest(")
        append("assetId=$assetId,")
        append("endTimeInSeconds=$endTimeInSeconds,")
        append("endTimeOffsetInNanos=$endTimeOffsetInNanos,")
        append("intervalInSeconds=$intervalInSeconds,")
        append("intervalWindowInSeconds=$intervalWindowInSeconds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("quality=$quality,")
        append("startTimeInSeconds=$startTimeInSeconds,")
        append("startTimeOffsetInNanos=$startTimeOffsetInNanos,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (endTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (endTimeOffsetInNanos ?: 0)
        result = 31 * result + (intervalInSeconds?.hashCode() ?: 0)
        result = 31 * result + (intervalWindowInSeconds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (quality?.hashCode() ?: 0)
        result = 31 * result + (startTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (startTimeOffsetInNanos ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetInterpolatedAssetPropertyValuesRequest

        if (assetId != other.assetId) return false
        if (endTimeInSeconds != other.endTimeInSeconds) return false
        if (endTimeOffsetInNanos != other.endTimeOffsetInNanos) return false
        if (intervalInSeconds != other.intervalInSeconds) return false
        if (intervalWindowInSeconds != other.intervalWindowInSeconds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (quality != other.quality) return false
        if (startTimeInSeconds != other.startTimeInSeconds) return false
        if (startTimeOffsetInNanos != other.startTimeOffsetInNanos) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset, in UUID format.
         */
        public var assetId: kotlin.String? = null
        /**
         * The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.
         */
        public var endTimeInSeconds: kotlin.Long? = null
        /**
         * The nanosecond offset converted from `endTimeInSeconds`.
         */
        public var endTimeOffsetInNanos: kotlin.Int? = null
        /**
         * The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.
         */
        public var intervalInSeconds: kotlin.Long? = null
        /**
         * The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval, minus the window to the timestamp of each interval plus the window. If not specified, the window ranges between the start time minus the interval and the end time plus the interval.
         *
         * + If you specify a value for the `intervalWindowInSeconds` parameter, the value for the `type` parameter must be `LINEAR_INTERPOLATION`.
         * + If a data point isn't found during the specified query window, IoT SiteWise won't return an interpolated value for the interval. This indicates that there's a gap in the ingested data points.
         * For example, you can get the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to compute the second interpolated value, and so on.
         */
        public var intervalWindowInSeconds: kotlin.Long? = null
        /**
         * The maximum number of results to return for each paginated request. If not specified, the default value is 10.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         */
        public var propertyAlias: kotlin.String? = null
        /**
         * The ID of the asset property, in UUID format.
         */
        public var propertyId: kotlin.String? = null
        /**
         * The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.
         */
        public var quality: aws.sdk.kotlin.services.iotsitewise.model.Quality? = null
        /**
         * The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.
         */
        public var startTimeInSeconds: kotlin.Long? = null
        /**
         * The nanosecond offset converted from `startTimeInSeconds`.
         */
        public var startTimeOffsetInNanos: kotlin.Int? = null
        /**
         * The interpolation type.
         *
         * Valid values: `LINEAR_INTERPOLATION | LOCF_INTERPOLATION`
         * + `LINEAR_INTERPOLATION` – Estimates missing data using [linear interpolation](https://en.wikipedia.org/wiki/Linear_interpolation).For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value on July 3, 2021, at 9 AM, and so on.
         * + `LOCF_INTERPOLATION` – Estimates missing data using last observation carried forward interpolationIf no data point is found for an interval, IoT SiteWise returns the last observed data point for the previous interval and carries forward this interpolated value until a new data point is found.For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest) : this() {
            this.assetId = x.assetId
            this.endTimeInSeconds = x.endTimeInSeconds
            this.endTimeOffsetInNanos = x.endTimeOffsetInNanos
            this.intervalInSeconds = x.intervalInSeconds
            this.intervalWindowInSeconds = x.intervalWindowInSeconds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.quality = x.quality
            this.startTimeInSeconds = x.startTimeInSeconds
            this.startTimeOffsetInNanos = x.startTimeOffsetInNanos
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest = GetInterpolatedAssetPropertyValuesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
